/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.war;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.SelectWarGoals;
import org.leralix.tan.gui.user.territory.WarsMenu;
import org.leralix.tan.gui.user.war.CreateAttackMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class WarMenu
extends BasicGui {
    private final TerritoryData territoryData;
    private final War war;
    private final WarRole warRole;

    public WarMenu(Player player, TerritoryData territoryData, War war) {
        super(player, Lang.HEADER_WARS_MENU, 3);
        this.territoryData = territoryData;
        this.war = war;
        this.warRole = war.isMainAttacker(territoryData) ? WarRole.MAIN_ATTACKER : WarRole.MAIN_DEFENDER;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getWarIcon());
        this.gui.setItem(2, 3, this.getWargoalsButton());
        this.gui.setItem(2, 4, this.getAttackButton());
        this.gui.setItem(2, 6, this.getEnemyWargoalsIcon());
        this.gui.setItem(2, 7, this.getSurrenderButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new WarsMenu(this.player, this.territoryData)));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getWarIcon() {
        return this.iconManager.get(this.war.getIcon()).setName(this.war.getName()).setDescription(Lang.ATTACK_ICON_DESC_1.get(this.war.getMainAttacker().getColoredName()), Lang.ATTACK_ICON_DESC_2.get(this.war.getMainDefender().getColoredName())).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getWargoalsButton() {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(Lang.WAR_GOAL_LIST_BUTTON_DESC1.get());
        for (WarGoal goal : this.war.getGoals(this.warRole)) {
            description.add(Lang.WAR_GOAL_LIST_BUTTON_LIST.get(goal.getCurrentDesc(this.langType)));
        }
        if (description.size() == 1) {
            description.add(Lang.WAR_GOAL_LIST_BUTTON_LIST_NO_WAR_GOAL_SET.get());
        }
        return this.iconManager.get(IconKey.WAR_GOAL_LIST_ICON).setName(Lang.WAR_GOAL_LIST_BUTTON.get(this.langType, new String[0])).setDescription(description).setAction(action -> new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole)).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getAttackButton() {
        return this.iconManager.get(IconKey.WAR_CREATE_ATTACK_ICON).setName(Lang.WAR_CREATE_ATTACK.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> new CreateAttackMenu(this.player, this.territoryData, this.war, this.warRole)).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getEnemyWargoalsIcon() {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(Lang.WAR_ENEMY_GOAL_LIST_DESC1.get());
        for (WarGoal goal : this.war.getGoals(this.warRole.opposite())) {
            description.add(Lang.WAR_GOAL_LIST_BUTTON_LIST.get(goal.getCurrentDesc(this.langType)));
        }
        if (description.size() == 1) {
            description.add(Lang.WAR_GOAL_LIST_BUTTON_LIST_NO_WAR_GOAL_SET.get());
        }
        return this.iconManager.get(IconKey.WAR_ENEMY_GOAL_LIST_ICON).setName(Lang.WAR_ENEMY_GOAL_LIST.get(this.langType, new String[0])).setDescription(description).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getSurrenderButton() {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(Lang.WAR_SURRENDER_DESC1.get());
        description.add(Lang.WAR_SURRENDER_DESC2.get());
        description.addAll(this.war.generateWarGoalsDesciption(this.warRole, this.langType));
        return this.iconManager.get(IconKey.WAR_SURRENDER_ICON).setName(Lang.WAR_SURRENDER.get(this.langType, new String[0])).setDescription(description).setAction(action -> {
            this.war.territorySurrender(this.warRole);
            new WarsMenu(this.player, this.territoryData);
        }).asGuiItem(this.player, this.langType);
    }
}

