/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners;

import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Allay;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.projectiles.ProjectileSource;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.storage.SudoPlayerStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.constants.Constants;

public class ChunkListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block breakedBlock = event.getBlock();
        Location loc = breakedBlock.getLocation();
        if (breakedBlock.hasMetadata("propertySign")) {
            event.setCancelled(true);
            return;
        }
        if (breakedBlock.hasMetadata("fortFlag")) {
            event.setCancelled(true);
            return;
        }
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.BREAK_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketFillEvent(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Location loc = event.getBlock().getLocation();
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.BREAK_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBucketEmptyEvent(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Location loc = event.getBlock().getLocation();
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.PLACE_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        Sign sign;
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockData blockData = block.getBlockData();
        Material materialType = block.getType();
        Material materialBlock = blockData.getMaterial();
        Location loc = block.getLocation();
        if (block.getType() == Material.OAK_SIGN && (sign = (Sign)block.getState()).hasMetadata("propertySign")) {
            event.setCancelled(true);
            return;
        }
        if (Tag.BUTTONS.isTagged((Keyed)materialType) || materialBlock == Material.LEVER) {
            if (!this.canPlayerDoAction(loc, event.getPlayer(), ChunkPermissionType.INTERACT_BUTTON)) {
                event.setCancelled(true);
            }
        } else if (materialBlock == Material.CHEST || materialBlock == Material.TRAPPED_CHEST || materialBlock == Material.BARREL || materialBlock == Material.HOPPER || materialBlock == Material.DISPENSER || materialBlock == Material.DROPPER || materialBlock == Material.BREWING_STAND || materialBlock == Material.SHULKER_BOX || materialBlock == Material.WHITE_SHULKER_BOX || materialBlock == Material.ORANGE_SHULKER_BOX || materialBlock == Material.MAGENTA_SHULKER_BOX || materialBlock == Material.LIGHT_BLUE_SHULKER_BOX || materialBlock == Material.YELLOW_SHULKER_BOX || materialBlock == Material.LIME_SHULKER_BOX || materialBlock == Material.PINK_SHULKER_BOX || materialBlock == Material.GRAY_SHULKER_BOX || materialBlock == Material.LIGHT_GRAY_SHULKER_BOX || materialBlock == Material.CYAN_SHULKER_BOX || materialBlock == Material.PURPLE_SHULKER_BOX || materialBlock == Material.BLUE_SHULKER_BOX || materialBlock == Material.BROWN_SHULKER_BOX || materialBlock == Material.GREEN_SHULKER_BOX || materialBlock == Material.RED_SHULKER_BOX || materialBlock == Material.BLACK_SHULKER_BOX) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_CHEST)) {
                event.setCancelled(true);
            }
        } else if (Tag.DOORS.isTagged((Keyed)materialType) || Tag.TRAPDOORS.isTagged((Keyed)materialType) || Tag.FENCE_GATES.isTagged((Keyed)materialType)) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_DOOR)) {
                event.setCancelled(true);
            }
        } else if (Tag.CANDLES.isTagged((Keyed)materialType) || Tag.CANDLE_CAKES.isTagged((Keyed)materialType) || Tag.FLOWER_POTS.isTagged((Keyed)materialType) || Tag.CAULDRONS.isTagged((Keyed)materialType) || materialBlock == Material.COMPOSTER || Tag.ALL_SIGNS.isTagged((Keyed)materialType) || materialBlock == Material.CHISELED_BOOKSHELF || Tag.CAMPFIRES.isTagged((Keyed)materialType) || materialBlock == Material.BEACON) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_DECORATIVE_BLOCK)) {
                event.setCancelled(true);
            }
        } else if (materialBlock == Material.JUKEBOX || materialBlock == Material.NOTE_BLOCK) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_MUSIC_BLOCK)) {
                event.setCancelled(true);
            }
        } else if (materialBlock == Material.REDSTONE_WIRE || materialBlock == Material.REPEATER || materialBlock == Material.COMPARATOR || materialBlock == Material.DAYLIGHT_DETECTOR) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_REDSTONE)) {
                event.setCancelled(true);
            }
        } else if (event.getItem() != null && event.getItem().getType() == Material.BONE_MEAL) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.USE_BONE_MEAL)) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.SWEET_BERRY_BUSH) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_BERRIES)) {
                event.setCancelled(true);
            }
        } else if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && player.getItemInHand().getType() == Material.OAK_BOAT) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_BOAT)) {
                event.setCancelled(true);
            }
        } else if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && player.getItemInHand().getType() == Material.MINECART) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_MINECART)) {
                event.setCancelled(true);
            }
        } else if (event.getAction() == Action.PHYSICAL && event.getClickedBlock().getType() == Material.FARMLAND && !this.canPlayerDoAction(loc, player, ChunkPermissionType.BREAK_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlocPlaced(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Location loc = event.getBlock().getLocation();
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.PLACE_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Projectile projectile;
        Location loc;
        Entity entity;
        Entity entity2 = event.getDamager();
        if (entity2 instanceof Player) {
            Player player2;
            Player player = (Player)entity2;
            entity = event.getEntity();
            loc = entity.getLocation();
            if (entity instanceof Allay || entity instanceof Axolotl || entity instanceof Bat || entity instanceof Camel || entity instanceof Cat || entity instanceof Chicken || entity instanceof Cow || entity instanceof Donkey || entity instanceof Fox || entity instanceof Frog || entity instanceof Horse || entity instanceof Mule || entity instanceof Ocelot || entity instanceof Parrot || entity instanceof Pig || entity instanceof Rabbit || entity instanceof Sheep || entity instanceof SkeletonHorse || entity instanceof Sniffer || entity instanceof Snowman || entity instanceof Squid || entity instanceof Strider || entity instanceof Turtle || entity instanceof Villager || entity instanceof WanderingTrader || entity instanceof Fish || entity instanceof Bee || entity instanceof Dolphin || entity instanceof Goat || entity instanceof IronGolem || entity instanceof Llama || entity instanceof Panda || entity instanceof PolarBear || entity instanceof Wolf || entity instanceof ArmorStand) {
                if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.ATTACK_PASSIVE_MOB)) {
                    event.setCancelled(true);
                }
            } else if (entity instanceof ItemFrame) {
                if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_ITEM_FRAME)) {
                    event.setCancelled(true);
                }
            } else if (entity instanceof EnderCrystal) {
                if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.BREAK_BLOCK)) {
                    event.setCancelled(true);
                }
            } else if (entity instanceof Player && !this.canPvpHappen(player, player2 = (Player)entity)) {
                event.setCancelled(true);
            }
        }
        if ((entity = event.getDamager()) instanceof Projectile && (loc = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            Player player2;
            Player player = (Player)loc;
            Entity entity3 = event.getEntity();
            Location loc2 = entity3.getLocation();
            if (entity3 instanceof Allay || entity3 instanceof Axolotl || entity3 instanceof Bat || entity3 instanceof Camel || entity3 instanceof Cat || entity3 instanceof Chicken || entity3 instanceof Cow || entity3 instanceof Donkey || entity3 instanceof Fox || entity3 instanceof Frog || entity3 instanceof Horse || entity3 instanceof Mule || entity3 instanceof Ocelot || entity3 instanceof Parrot || entity3 instanceof Pig || entity3 instanceof Rabbit || entity3 instanceof Sheep || entity3 instanceof SkeletonHorse || entity3 instanceof Sniffer || entity3 instanceof Snowman || entity3 instanceof Squid || entity3 instanceof Strider || entity3 instanceof Turtle || entity3 instanceof Villager || entity3 instanceof WanderingTrader || entity3 instanceof Fish || entity3 instanceof Bee || entity3 instanceof Dolphin || entity3 instanceof Goat || entity3 instanceof IronGolem || entity3 instanceof Llama || entity3 instanceof Panda || entity3 instanceof PolarBear || entity3 instanceof Wolf || entity3 instanceof ArmorStand) {
                if (!this.canPlayerDoAction(loc2, player, ChunkPermissionType.ATTACK_PASSIVE_MOB)) {
                    event.setCancelled(true);
                }
            } else if (entity3 instanceof ItemFrame) {
                if (!this.canPlayerDoAction(loc2, player, ChunkPermissionType.INTERACT_ITEM_FRAME)) {
                    event.setCancelled(true);
                }
            } else if (entity3 instanceof EnderCrystal) {
                if (!this.canPlayerDoAction(loc2, player, ChunkPermissionType.BREAK_BLOCK)) {
                    event.setCancelled(true);
                }
            } else if (entity3 instanceof Player && !this.canPvpHappen(player, player2 = (Player)entity3)) {
                event.setCancelled(true);
            }
        }
    }

    private boolean canPvpHappen(Player player1, Player player2) {
        if (!NewClaimedChunkStorage.getInstance().get(player2.getLocation().getChunk()).canPVPHappen()) {
            return false;
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player1);
        ITanPlayer tanPlayer2 = PlayerDataStorage.getInstance().get(player2);
        TownRelation relation = tanPlayer.getRelationWithPlayer(tanPlayer2);
        return Constants.getRelationConstants(relation).canPvP();
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (event.getInventory() instanceof FurnaceInventory || event.getInventory() instanceof BlastFurnace || event.getInventory() instanceof Smoker) {
                Location loc = event.getInventory().getLocation();
                if (loc == null) {
                    return;
                }
                if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_FURNACE)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            loc = itemFrame.getLocation();
            if (!this.canPlayerDoAction((Location)loc, player, ChunkPermissionType.INTERACT_ITEM_FRAME)) {
                event.setCancelled(true);
            }
        } else {
            loc = event.getRightClicked();
            if (loc instanceof LeashHitch) {
                LeashHitch leashHitch = (LeashHitch)loc;
                if (!this.canPlayerDoAction((Location)(loc = leashHitch.getLocation()), player, ChunkPermissionType.USE_LEAD)) {
                    event.setCancelled(true);
                }
            } else {
                LivingEntity livingEntity;
                loc = event.getRightClicked();
                if (loc instanceof LivingEntity && (livingEntity = (LivingEntity)loc).isLeashed() && !this.canPlayerDoAction((Location)(loc = livingEntity.getLocation()), player, ChunkPermissionType.USE_LEAD)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            Player player = event.getPlayer();
            Location loc = armorStand.getLocation();
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.INTERACT_ARMOR_STAND)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerLeashEntityEvent(PlayerLeashEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Location loc = entity.getLocation();
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.USE_LEAD)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreakByEntityEvent(HangingBreakByEntityEvent event) {
        Projectile projectile;
        ProjectileSource loc2;
        Entity remover = event.getRemover();
        if (remover instanceof Player) {
            Player player = (Player)remover;
            Hanging entity = event.getEntity();
            Location loc2 = entity.getLocation();
            if (entity instanceof LeashHitch) {
                if (!this.canPlayerDoAction(loc2, player, ChunkPermissionType.USE_LEAD)) {
                    event.setCancelled(true);
                }
            } else if (!this.canPlayerDoAction(loc2, player, ChunkPermissionType.BREAK_BLOCK)) {
                event.setCancelled(true);
            }
        } else if (remover instanceof Projectile && (loc2 = (projectile = (Projectile)remover).getShooter()) instanceof Player) {
            Player player = (Player)loc2;
            Hanging entity = event.getEntity();
            Location loc3 = entity.getLocation();
            if (entity instanceof LeashHitch) {
                if (!this.canPlayerDoAction(loc3, player, ChunkPermissionType.USE_LEAD)) {
                    event.setCancelled(true);
                }
            } else if (!this.canPlayerDoAction(loc3, player, ChunkPermissionType.BREAK_BLOCK)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHangingPlaceEvent(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location loc = block.getLocation();
        Hanging entity = event.getEntity();
        if (entity instanceof LeashHitch) {
            if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.USE_LEAD)) {
                event.setCancelled(true);
            }
        } else if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.PLACE_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent event) {
        Player player = event.getPlayer();
        Location loc = event.getEntity().getLocation();
        if (!this.canPlayerDoAction(loc, player, ChunkPermissionType.USE_SHEARS)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onExplosion(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> !NewClaimedChunkStorage.getInstance().get(block.getChunk()).canExplosionGrief());
    }

    @EventHandler
    public void onBurning(BlockBurnEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (!NewClaimedChunkStorage.getInstance().get(chunk).canFireGrief()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFireSpreading(BlockSpreadEvent event) {
        if (event.getSource().getType() == Material.FIRE) {
            Chunk chunk = event.getBlock().getChunk();
            if (!NewClaimedChunkStorage.getInstance().get(chunk).canFireGrief()) {
                event.setCancelled(true);
            }
        }
    }

    private boolean canPlayerDoAction(Location location, Player player, ChunkPermissionType permissionType) {
        if (SudoPlayerStorage.isSudoPlayer(player)) {
            return true;
        }
        ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(location.getChunk());
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        if (tanPlayer.isAtWarWith(claimedChunk.getOwner())) {
            return true;
        }
        return claimedChunk.canPlayerDo(player, permissionType, location);
    }

    public void onWitherBlockBreak(EntityChangeBlockEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (!NewClaimedChunkStorage.getInstance().get(chunk).canMobGrief()) {
            event.setCancelled(true);
        }
    }
}

