/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.chat.events;

import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.gui.admin.AdminManagePlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.ChatListenerEvent;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminSetPlayerBalance
extends ChatListenerEvent {
    private final ITanPlayer targetPlayer;

    public AdminSetPlayerBalance(ITanPlayer targetPlayer) {
        this.targetPlayer = targetPlayer;
    }

    @Override
    protected boolean execute(Player player, String message) {
        Double amount = AdminSetPlayerBalance.parseStringToDouble(message);
        if (amount == null) {
            TanChatUtils.message(player, Lang.SYNTAX_ERROR_AMOUNT.get(player));
            return false;
        }
        EconomyUtil.setBalance(this.targetPlayer, amount);
        SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
        this.openGui(p -> new AdminManagePlayer(player, this.targetPlayer), player);
        return true;
    }
}

