/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions;

import dev.triumphteam.gui.guis.GuiItem;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.upgrade.NewUpgradeStorage;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public abstract class AbstractTransaction {
    protected long localDate;

    protected AbstractTransaction() {
        this.localDate = new Date().getTime();
    }

    protected AbstractTransaction(long timestamp) {
        this.localDate = timestamp;
    }

    public long getDate() {
        return this.localDate;
    }

    public abstract TransactionType getType();

    public abstract GuiItem getIcon(IconManager var1, Player var2, LangType var3);

    public abstract String getInsertSQL();

    protected String getPlayerName(String playerID, LangType langType) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerID));
        String playerName = offlinePlayer.getName();
        if (playerName == null) {
            return Lang.PLAYER_NOT_FOUND.get(langType, new String[0]);
        }
        return offlinePlayer.getName();
    }

    protected String getTerritoryName(String id, LangType langType) {
        TerritoryData territoryData = TerritoryUtil.getTerritory(id);
        if (territoryData == null) {
            return Lang.TERRITORY_NOT_FOUND.get(langType, new String[0]);
        }
        return territoryData.getColoredName();
    }

    protected String getPropertyName(String territoryID, String propertyID, LangType langType) {
        TerritoryData territoryData = TerritoryUtil.getTerritory(territoryID);
        if (territoryData == null) {
            return Lang.TERRITORY_NOT_FOUND.get(langType, new String[0]);
        }
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            PropertyData propertyData = townData.getPropertyDataMap().get(propertyID);
            if (propertyData == null) {
                return Lang.PROPERTY_NOT_FOUND.get(langType, new String[0]);
            }
            return propertyData.getName();
        }
        return Lang.PROPERTY_NOT_FOUND.get(langType, new String[0]);
    }

    protected String getUpgradeName(String territoryID, String upgradeID, LangType langType) {
        TerritoryData territoryData = TerritoryUtil.getTerritory(territoryID);
        NewUpgradeStorage upgradeStorage = Constants.getUpgradeStorage();
        if (territoryData == null) {
            return Lang.TERRITORY_NOT_FOUND.get(langType, new String[0]);
        }
        Upgrade upgrade = upgradeStorage.getUpgrade(territoryData, upgradeID);
        if (upgrade == null) {
            return Lang.UPGRADE_NOT_FOUND.get(langType, new String[0]);
        }
        return upgrade.getName(langType);
    }

    @NotNull
    protected String getColoredName(String id, LangType langType) {
        if (id.startsWith("T") || id.startsWith("R")) {
            return this.getTerritoryName(id, langType);
        }
        return this.getPlayerName(id, langType);
    }

    public static <T extends AbstractTransaction> T fromResultSet(ResultSet rs, Class<T> clazz) throws SQLException {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(ResultSet.class);
            return (T)((AbstractTransaction)constructor.newInstance(rs));
        }
        catch (ReflectiveOperationException e) {
            throw new SQLException("Failed to instantiate " + clazz.getSimpleName() + " (" + e.getMessage() + ")", e);
        }
    }

    public abstract void fillInsertStatement(PreparedStatement var1) throws SQLException;

    public abstract Set<String> getConcerned();
}

