/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions;

import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.deprecated.DisplayableEnum;

public enum TransactionType implements DisplayableEnum
{
    INDEX(Lang.ALL_TRANSACTION_SCOPE, "transaction_index", "        id %s,\n        id_transaction BIGINT NOT NULL,\n        concerned VARCHAR(32) NOT NULL,\n        type VARCHAR(32) NOT NULL\n    );\n"),
    PAYMENT(Lang.PAYMENT_TRANSACTION_SCOPE, "transaction_payment", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        sender_id BIGINT NOT NULL,\n        receiver_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL\n    );\n"),
    DONATION(Lang.DONATION_TRANSACTION_SCOPE, "transaction_donation", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        player_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL\n    );\n"),
    RETRIEVE(Lang.RETRIEVE_TRANSACTION_SCOPE, "transaction_retrieve", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        player_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL\n    );\n"),
    TAXES(Lang.TAXES_TRANSACTION_SCOPE, "transaction_taxes", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        player_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        enough_money SMALLINT NOT NULL CHECK (enough_money IN (0, 1))\n    );\n"),
    SALARY(Lang.SALARY_TRANSACTION_SCOPE, "transaction_salary", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        player_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL\n    );\n"),
    CREATE_PROPERTY(Lang.CREATE_PROPERTY_TRANSACTION_SCOPE, "transaction_create_property", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        property_id VARCHAR(32) NOT NULL,\n        territory_id BIGINT NOT NULL,\n        creator_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        tax_per_block DOUBLE PRECISION NOT NULL\n    );\n"),
    SELLING_PROPERTY(Lang.SELL_PROPERTY_TRANSACTION_SCOPE, "transaction_selling_property", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        property_id VARCHAR(32) NOT NULL,\n        territory_id BIGINT NOT NULL,\n        seller_id BIGINT NOT NULL,\n        buyer_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        tax_percentage DOUBLE PRECISION NOT NULL\n    );\n"),
    RENTING_PROPERTY(Lang.RENT_PROPERTY_TRANSACTION_SCOPE, "transaction_renting_property", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        property_id VARCHAR(32) NOT NULL,\n        player_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        tax_percentage DOUBLE PRECISION NOT NULL\n    );\n"),
    CHANGE_TERRITORY_NAME(Lang.CHANGE_TERRITORY_NAME_TRANSACTION_SCOPE, "transaction_change_territory_name", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        tax_percentage DOUBLE PRECISION NOT NULL\n    );\n"),
    UPGRADE(Lang.UPGRADE_TRANSACTION_SCOPE, "transaction_upgrades", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        upgrade_id BIGINT NOT NULL,\n        upgrade_new_level INT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL\n    );\n"),
    TERRITORY_TAX(Lang.TERRITORY_TAXES_TRANSACTION_SCOPE, "transaction_territory_taxes", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        sender_id BIGINT NOT NULL,\n        receiver_id BIGINT NOT NULL,\n        amount DOUBLE PRECISION NOT NULL,\n        enough_money SMALLINT NOT NULL CHECK (enough_money IN (0, 1))\n    );\n"),
    TERRITORY_CHUNK_UPKEEP(Lang.TERRITORY_CHUNK_UPKEEP_TRANSACTION_SCOPE, "transaction_territory_chunk_upkeep", "        id %s,\n        timestamp TIMESTAMP NOT NULL,\n        territory_id BIGINT NOT NULL,\n        cost_per_chunk DOUBLE PRECISION NOT NULL,\n        number_of_chunks INT NOT NULL,\n        enough_money SMALLINT NOT NULL CHECK (enough_money IN (0, 1))\n    );\n");

    private final Lang name;
    private final String tableName;
    private final String createTableSQL;

    private TransactionType(Lang name, String tableName, String createTableSQL) {
        this.name = name;
        this.tableName = tableName;
        this.createTableSQL = createTableSQL;
    }

    public String getCreateTableSQL(String autoIncrementSyntax) {
        String title = "CREATE TABLE IF NOT EXISTS %s (".formatted(this.tableName);
        return title + this.createTableSQL.formatted(autoIncrementSyntax);
    }

    @Override
    public String getDisplayName(LangType langType) {
        return this.name.get(langType, new String[0]);
    }

    public String getTableName() {
        return this.tableName;
    }
}

