/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.storage.database.transactions.instance.PlayerTaxTransaction;
import org.leralix.tan.utils.text.DateUtil;

public class DailyPlayerTaxTransaction
extends AbstractTransaction {
    private final List<PlayerTaxTransaction> transactions;
    private final double totalAmount;

    public DailyPlayerTaxTransaction(List<PlayerTaxTransaction> transactions) {
        super(transactions.getFirst().getDate());
        this.transactions = transactions;
        this.totalAmount = transactions.stream().mapToDouble(PlayerTaxTransaction::getAmount).sum();
    }

    @Override
    public TransactionType getType() {
        return TransactionType.TAXES;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        IconBuilder icon = iconManager.get(IconKey.PLAYER_TAX_TRANSACTION).setName(Lang.PLAYER_TAX_TRANSACTION.get(langType, new String[0])).setDescription(Lang.TRANSACTION_DATE.get(DateUtil.getRelativeTimeDescription(langType, this.getDate())), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.totalAmount)));
        for (PlayerTaxTransaction transaction : this.transactions) {
            icon.addDescription(transaction.getDailyLine(langType));
        }
        return icon.asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return null;
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
    }

    @Override
    public Set<String> getConcerned() {
        return Collections.emptySet();
    }
}

