/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.utils.text.DateUtil;

public class RetrieveTransaction
extends AbstractTransaction {
    private final String playerID;
    private final String territoryID;
    private final double amount;

    public RetrieveTransaction(TerritoryData territoryData, Player player, double amount) {
        this.playerID = player.getUniqueId().toString();
        this.territoryID = territoryData.getID();
        this.amount = amount;
    }

    public RetrieveTransaction(ResultSet rs) throws SQLException {
        this.localDate = rs.getLong("timestamp");
        this.territoryID = rs.getString("territory_id");
        this.playerID = rs.getString("player_id");
        this.amount = rs.getDouble("amount");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.RETRIEVE;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.WITHDRAWAL_TRANSACTION).setName(Lang.RETRIEVE_TRANSACTION_NAME.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getTerritoryName(this.territoryID, langType)), Lang.TRANSACTION_TO.get(this.getPlayerName(this.playerID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount)), Lang.TRANSACTION_DATE.get(DateUtil.getRelativeTimeDescription(langType, this.getDate()))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_retrieve (timestamp, player_id, territory_id, amount) VALUES (?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate());
        ps.setString(2, this.playerID);
        ps.setString(3, this.territoryID);
        ps.setDouble(4, this.amount);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.playerID);
        res.add(this.territoryID);
        return res;
    }

    public String getPlayerID() {
        return this.playerID;
    }

    public String getTerritoryID() {
        return this.territoryID;
    }

    public double getAmount() {
        return this.amount;
    }
}

