/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.utils.text.DateUtil;
import org.leralix.tan.utils.text.NumberUtil;

public class TerritoryChunkUpkeepTransaction
extends AbstractTransaction {
    private final String territoryID;
    private final double costPerChunk;
    private final int numberOfChunks;
    private final boolean enoughMoney;

    public TerritoryChunkUpkeepTransaction(String territoryID, double costPerChunk, int numberOfChunks, boolean enoughMoney) {
        this.territoryID = territoryID;
        this.costPerChunk = costPerChunk;
        this.numberOfChunks = numberOfChunks;
        this.enoughMoney = enoughMoney;
    }

    public TerritoryChunkUpkeepTransaction(ResultSet rs) throws SQLException {
        this.localDate = rs.getLong("timestamp");
        this.territoryID = rs.getString("territory_id");
        this.costPerChunk = rs.getDouble("cost_per_chunk");
        this.numberOfChunks = rs.getInt("number_of_chunks");
        this.enoughMoney = rs.getBoolean("enough_money");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.TERRITORY_CHUNK_UPKEEP;
    }

    public double getCost() {
        return NumberUtil.roundWithDigits(this.costPerChunk * (double)this.numberOfChunks);
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.CHUNK_UPKEEP_TRANSACTION).setName(Lang.TERRITORY_CHUNK_UPKEEP_TRANSACTION_SCOPE.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getTerritoryName(this.territoryID, langType)), this.enoughMoney ? Lang.TRANSACTION_AMOUNT.get(Double.toString(this.getCost())) : Lang.TRANSACTION_FAILED_NOT_ENOUGH_MONEY.get(Double.toString(this.getCost())), Lang.CHUNK_UPKEEP_INFO.get(Integer.toString(this.numberOfChunks), Double.toString(this.costPerChunk)), Lang.TRANSACTION_DATE.get(DateUtil.getRelativeTimeDescription(langType, this.getDate()))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_territory_chunk_upkeep (timestamp, territory_id, cost_per_chunk, number_of_chunks, enough_money) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate());
        ps.setString(2, this.territoryID);
        ps.setDouble(3, this.costPerChunk);
        ps.setInt(4, this.numberOfChunks);
        ps.setBoolean(5, this.enoughMoney);
    }

    @Override
    public Set<String> getConcerned() {
        return Set.of(this.territoryID);
    }
}

