/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.typeadapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.leralix.tan.TownsAndNations;

public class EnumMapDeserializer<E extends Enum<E>, V>
implements JsonDeserializer<Map<E, V>> {
    private final Class<E> enumClass;
    private final Type valueType;

    public EnumMapDeserializer(Class<E> enumClass, Type valueType) {
        this.enumClass = enumClass;
        this.valueType = valueType;
    }

    @Override
    public Map<E, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMap resultMap = new HashMap();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            E enumValue;
            String key = entry.getKey();
            try {
                enumValue = Enum.valueOf(this.enumClass, key);
            }
            catch (IllegalArgumentException e) {
                TownsAndNations.getPlugin().getLogger().warning("Invalid key (probably older version) deleted: " + key);
                continue;
            }
            Object value = context.deserialize(entry.getValue(), this.valueType);
            resultMap.put(enumValue, value);
        }
        return resultMap;
    }
}

