/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.typeadapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.leralix.tan.TownsAndNations;

public class EnumMapKeyValueDeserializer<K extends Enum<K>, V extends Enum<V>>
implements JsonDeserializer<Map<K, V>> {
    private final Class<K> keyEnumClass;
    private final Class<V> valueEnumClass;

    public EnumMapKeyValueDeserializer(Class<K> keyEnumClass, Class<V> valueEnumClass) {
        this.keyEnumClass = keyEnumClass;
        this.valueEnumClass = valueEnumClass;
    }

    @Override
    public Map<K, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMap<K, V> resultMap = new HashMap<K, V>();
        JsonObject jsonObject = json.getAsJsonObject();
        Logger logger = TownsAndNations.getPlugin().getLogger();
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            V enumValue;
            K enumKey;
            String keyString = entry.getKey();
            String valueString = entry.getValue().getAsString();
            try {
                enumKey = Enum.valueOf(this.keyEnumClass, keyString);
                enumValue = Enum.valueOf(this.valueEnumClass, valueString);
            }
            catch (IllegalArgumentException e) {
                logger.warning("Invalid key (probably older version) deleted: " + keyString);
                continue;
            }
            resultMap.put(enumKey, enumValue);
        }
        return resultMap;
    }
}

