/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.timezone;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.timezone.TimeZoneEnum;

public class TimeZoneManager {
    private static TimeZoneManager instance;
    private TimeZoneEnum timeZoneEnum = this.getServerTimeZone();

    private TimeZoneManager() {
    }

    public static TimeZoneManager getInstance() {
        if (instance == null) {
            instance = new TimeZoneManager();
        }
        return instance;
    }

    private TimeZoneEnum getServerTimeZone() {
        ZoneOffset offset = ZonedDateTime.now().getOffset();
        return TimeZoneEnum.fromOffset(offset.getTotalSeconds() / 3600);
    }

    public FilledLang formatDateNowForPlayer(ITanPlayer tanPlayer) {
        return this.formatDateForPlayer(tanPlayer, Instant.now());
    }

    public FilledLang formatDateForPlayer(ITanPlayer tanPlayer, Instant timestamp) {
        return this.formatDate(timestamp, tanPlayer.getTimeZone(), tanPlayer.getLang().getLocale());
    }

    public FilledLang formatDate(Instant timestamp, TimeZoneEnum timeZone, Locale locale) {
        return TimeZoneManager.getDate(timestamp, timeZone, locale);
    }

    public FilledLang formatDateNowForServer() {
        return this.formatDateForServer(Instant.now());
    }

    public FilledLang formatDateForServer(Instant timestamp) {
        return TimeZoneManager.getDate(timestamp, this.getServerTimeZone(), Lang.getServerLang().getLocale());
    }

    private static FilledLang getDate(Instant timestamp, TimeZoneEnum timeZone, Locale locale) {
        ZonedDateTime zonedDateTime = timestamp.atZone(timeZone.toZoneOffset());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMMM yyyy HH:mm").withLocale(locale);
        return Lang.STRING.get(formatter.format(zonedDateTime));
    }

    public TimeZoneEnum getTimezoneEnum() {
        return this.timeZoneEnum;
    }

    public void setTimeZoneEnum(TimeZoneEnum timeZoneEnum) {
        this.timeZoneEnum = timeZoneEnum;
    }

    public boolean isDayForServer() {
        ZonedDateTime zonedDateTime = Instant.now().atZone(this.getServerTimeZone().toZoneOffset());
        int hourOfDay = zonedDateTime.getHour();
        return hourOfDay >= 8 && hourOfDay < 20;
    }
}

