/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.libs.exp4j.Expression;
import org.leralix.tan.libs.exp4j.ExpressionBuilder;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.IndividualStat;
import org.leralix.tan.upgrade.rewards.StatsType;
import org.leralix.tan.upgrade.rewards.bool.EnableMobBan;
import org.leralix.tan.upgrade.rewards.bool.EnableTownSpawn;
import org.leralix.tan.upgrade.rewards.list.BiomeStat;
import org.leralix.tan.upgrade.rewards.list.PermissionList;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCap;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCost;
import org.leralix.tan.upgrade.rewards.numeric.LandmarkCap;
import org.leralix.tan.upgrade.rewards.numeric.PropertyCap;
import org.leralix.tan.upgrade.rewards.numeric.TownPlayerCap;
import org.leralix.tan.upgrade.rewards.percentage.LandmarkBonus;
import org.leralix.tan.utils.constants.Constants;

public class TerritoryStats {
    private int mainLevel = 1;
    private Map<String, Integer> level = new HashMap<String, Integer>();
    private final StatsType statsType;

    public TerritoryStats(StatsType statsType) {
        this.level.put("CITY_HALL", 1);
        this.statsType = statsType;
    }

    public int getLevel(Upgrade upgrade) {
        if (this.level == null) {
            this.level = new HashMap<String, Integer>();
        }
        if (!this.level.containsKey(upgrade.getID())) {
            return 0;
        }
        return this.level.get(upgrade.getID());
    }

    public void levelUp(Upgrade townUpgrade) {
        String key = townUpgrade.getID();
        if (!this.level.containsKey(key)) {
            this.level.put(key, 1);
            return;
        }
        this.level.put(key, this.level.get(key) + 1);
    }

    public int getMainLevel() {
        return this.mainLevel;
    }

    public void levelUpMain() {
        ++this.mainLevel;
    }

    public <T extends IndividualStat> T getStat(Class<T> rewardClass) {
        ArrayList<IndividualStat> stats = new ArrayList<IndividualStat>();
        for (Upgrade upgrade : Constants.getUpgradeStorage().getUpgrades(this.statsType)) {
            int currentLevel = this.getLevel(upgrade);
            if (currentLevel == 0) continue;
            for (IndividualStat reward : upgrade.getRewards()) {
                if (!rewardClass.isInstance(reward)) continue;
                stats.add((IndividualStat)((AggregatableStat)((Object)((IndividualStat)rewardClass.cast(reward)))).scale(currentLevel));
            }
        }
        if (stats.isEmpty()) {
            try {
                return (T)((IndividualStat)rewardClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create default instance of " + rewardClass.getName(), e);
            }
        }
        return (T)((IndividualStat)((AggregatableStat)((Object)((IndividualStat)stats.getFirst()))).aggregate(stats));
    }

    public Collection<IndividualStat> getAllStats() {
        ArrayList<IndividualStat> allStats = new ArrayList<IndividualStat>();
        allStats.add(this.getStat(ChunkCap.class));
        allStats.add(this.getStat(ChunkCost.class));
        if (this.statsType == StatsType.TOWN) {
            allStats.add(this.getStat(LandmarkCap.class));
            allStats.add(this.getStat(PropertyCap.class));
            allStats.add(this.getStat(TownPlayerCap.class));
            allStats.add(this.getStat(LandmarkBonus.class));
            allStats.add(this.getStat(EnableTownSpawn.class));
            allStats.add(this.getStat(EnableMobBan.class));
        }
        allStats.add(this.getStat(PermissionList.class));
        allStats.add(this.getStat(BiomeStat.class));
        return allStats;
    }

    public int getMoneyRequiredForLevelUp() {
        return this.getRequiredMoney(this.mainLevel);
    }

    private int getRequiredMoney(int level) {
        FileConfiguration fg = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.UPGRADE);
        ConfigurationSection section = fg.getConfigurationSection("townLevelExpression");
        String expressionString = section.getString("LevelExpression");
        String squareMultName = "squareMultiplier";
        String flatMultName = "flatMultiplier";
        double squareMultiplier = section.getDouble(squareMultName);
        double flatMultiplier = section.getDouble(flatMultName);
        double base = section.getDouble("base");
        Expression expression = new ExpressionBuilder(expressionString).variable("level").variable(squareMultName).variable(flatMultName).variable("base").build().setVariable("level", level).setVariable(squareMultName, squareMultiplier).setVariable(flatMultName, flatMultiplier).setVariable("base", base);
        return (int)expression.evaluate();
    }
}

