/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.numeric;

import java.util.List;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.gui.service.requirements.PropertyCapRequirement;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.numeric.NumericStat;

public class LandmarkCap
extends NumericStat
implements AggregatableStat<LandmarkCap> {
    public LandmarkCap() {
        super(0, false);
    }

    public LandmarkCap(int maxAmount, boolean isUnlimited) {
        super(maxAmount, isUnlimited);
    }

    @Override
    public LandmarkCap aggregate(List<LandmarkCap> stats) {
        int totalCap = 0;
        boolean unlimitedFound = false;
        for (LandmarkCap stat : stats) {
            if (stat.isUnlimited) {
                unlimitedFound = true;
            }
            totalCap += stat.maxAmount;
        }
        return new LandmarkCap(totalCap, unlimitedFound);
    }

    @Override
    public LandmarkCap scale(int factor) {
        return new LandmarkCap(this.maxAmount * factor, this.isUnlimited);
    }

    public IndividualRequirement getRequirement(TownData townData) {
        return new PropertyCapRequirement(townData, this.maxAmount);
    }

    @Override
    public Lang getStatName() {
        return Lang.LANDMARK_CAP;
    }
}

