/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.percentage;

import java.util.List;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.IndividualStat;

public class LandmarkBonus
extends IndividualStat
implements AggregatableStat<LandmarkBonus> {
    private final double percentage;

    public LandmarkBonus() {
        this.percentage = 0.0;
    }

    public LandmarkBonus(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public LandmarkBonus aggregate(List<LandmarkBonus> stats) {
        double totalPercentage = 1.0;
        for (LandmarkBonus stat : stats) {
            totalPercentage *= 1.0 + stat.percentage;
        }
        return new LandmarkBonus(totalPercentage - 1.0);
    }

    @Override
    public LandmarkBonus scale(int factor) {
        return new LandmarkBonus(this.percentage * (double)factor);
    }

    @Override
    public FilledLang getStatReward(LangType langType, int level, int maxLevel) {
        int percentValue = (int)(this.percentage * (double)level * 100.0);
        int percentValueNext = (int)(this.percentage * (double)(level + 1) * 100.0);
        if (level >= maxLevel) {
            return Lang.UPGRADE_LINE_PERCENT_MAX.get(this.getStatName().get(langType, new String[0]), Integer.toString(percentValue));
        }
        return Lang.UPGRADE_LINE_PERCENT.get(this.getStatName().get(langType, new String[0]), Integer.toString(percentValue), Integer.toString(percentValueNext));
    }

    @Override
    public FilledLang getStatReward(LangType langType) {
        int percentValue = (int)((1.0 + this.percentage) * 100.0);
        return Lang.UPGRADE_LINE_PERCENT_MAX.get(this.getStatName().get(langType, new String[0]), Double.toString(percentValue));
    }

    @Override
    public Lang getStatName() {
        return Lang.LANDMARK_BONUS;
    }

    public double multiply(double baseValue) {
        return baseValue * (1.0 + this.percentage);
    }
}

