/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.deprecated;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;

public class HeadUtils {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    private HeadUtils() {
        throw new IllegalStateException("Utility class");
    }

    @NotNull
    public static ItemStack makeSkullURL(@NotNull String name, @NotNull String url, String ... lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(HeadUtils.createURL(url)), List.of(lore));
    }

    @NotNull
    public static ItemStack makeSkull(@NotNull String name, @NotNull PlayerProfile profile, List<String> lore) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwnerProfile(profile);
        meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + name);
        if (lore != null) {
            meta.setLore(lore);
        }
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private static PlayerProfile getProfile(URL url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        textures.setSkin(url);
        profile.setTextures(textures);
        return profile;
    }

    private static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            try {
                return new URL("http://textures.minecraft.net/texture/e7f9c6fef2ad96b3a5465642ba954671be1c4543e2e25e56aef0a47d5f1f");
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException("Invalid URL: " + url);
            }
        }
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, String ... loreLines) {
        List<String> lore = List.of(loreLines);
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, lore);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, List<String> lore) {
        ItemStack item = new ItemStack(itemMaterial);
        return HeadUtils.createCustomItemStack(item, itemName, lore);
    }

    public static ItemStack createCustomItemStack(ItemStack item, String itemName, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + itemName);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static void addLore(ItemStack itemStack, String ... loreLines) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> lore = itemMeta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.addAll(List.of(loreLines));
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
    }
}

