/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.territory;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.leralix.lib.position.Vector2D;
import org.leralix.tan.building.Building;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.territory.ChunkPolygon;

public class ChunkUtil {
    private static final NewClaimedChunkStorage claimedChunkStorage = NewClaimedChunkStorage.getInstance();

    private ChunkUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static boolean isChunkEncirecledBy(ClaimedChunk2 center, Predicate<ClaimedChunk2> predicate) {
        for (ClaimedChunk2 neighbor : claimedChunkStorage.getEightAjacentChunks(center)) {
            if (predicate.test(neighbor)) continue;
            return false;
        }
        return true;
    }

    public static List<ClaimedChunk2> getBorderChunks(TerritoryData territoryData) {
        ArrayList<ClaimedChunk2> res = new ArrayList<ClaimedChunk2>();
        for (TerritoryChunk territoryChunk : claimedChunkStorage.getAllChunkFrom(territoryData)) {
            if (ChunkUtil.isChunkEncirecledBy(territoryChunk, chunk -> territoryData.getID().equals(chunk.getOwnerID()))) continue;
            res.add(territoryChunk);
        }
        return res;
    }

    public static void unclaimIfNoLongerSupplied(TerritoryChunk unclaimedChunk) {
        ArrayList<ChunkPolygon> polygonsAnalysed = new ArrayList<ChunkPolygon>();
        for (ClaimedChunk2 claimedChunk2 : claimedChunkStorage.getEightAjacentChunks(unclaimedChunk)) {
            TerritoryChunk territoryChunk;
            if (!(claimedChunk2 instanceof TerritoryChunk) || ChunkUtil.alreadyAnalysed(territoryChunk = (TerritoryChunk)claimedChunk2, polygonsAnalysed)) continue;
            ChunkPolygon chunkPolygon = ChunkUtil.getPolygon(territoryChunk);
            if (!chunkPolygon.isSupplied()) {
                chunkPolygon.unclaimAll();
            }
            polygonsAnalysed.add(chunkPolygon);
        }
    }

    private static ChunkPolygon getPolygon(TerritoryChunk startChunk) {
        String ownerID = startChunk.getOwnerID();
        HashSet<CallSite> visited = new HashSet<CallSite>();
        HashSet<ClaimedChunk2> result = new HashSet<ClaimedChunk2>();
        LinkedList<ClaimedChunk2> toVisit = new LinkedList<ClaimedChunk2>();
        toVisit.add(startChunk);
        while (!toVisit.isEmpty()) {
            TerritoryChunk territoryChunk;
            ClaimedChunk2 current = (ClaimedChunk2)toVisit.poll();
            String key = current.getX() + "," + current.getZ() + "," + current.getWorldUUID();
            if (visited.contains(key)) continue;
            visited.add((CallSite)((Object)key));
            if (!(current instanceof TerritoryChunk) || !(territoryChunk = (TerritoryChunk)current).getOwnerID().equals(ownerID)) continue;
            result.add(current);
            List<ClaimedChunk2> adjacentChunks = claimedChunkStorage.getFourAjacentChunks(current);
            for (ClaimedChunk2 adj : adjacentChunks) {
                if (adj == null || visited.contains(adj.getX() + "," + adj.getZ() + "," + adj.getWorldUUID())) continue;
                toVisit.add(adj);
            }
        }
        return new ChunkPolygon(startChunk.getOwner(), result);
    }

    private static boolean alreadyAnalysed(ClaimedChunk2 claimedChunk2, List<ChunkPolygon> polygonsAnalysed) {
        for (ChunkPolygon chunkPolygon : polygonsAnalysed) {
            if (!chunkPolygon.contains(claimedChunk2)) continue;
            return true;
        }
        return false;
    }

    public static boolean chunkContainsBuildings(TerritoryChunk townClaimedChunk, TerritoryData territoryData) {
        TownData townData;
        Optional<Vector2D> optionalLocation;
        for (Building building : territoryData.getBuildings()) {
            if (!building.getPosition().getLocation().getChunk().equals((Object)townClaimedChunk.getChunk())) continue;
            return true;
        }
        if (territoryData instanceof TownData && (optionalLocation = (townData = (TownData)territoryData).getCapitalLocation()).isPresent()) {
            Vector2D location = optionalLocation.get();
            return location.getWorld().getChunkAt(location.getX(), location.getZ()).equals((Object)townClaimedChunk.getChunk());
        }
        return false;
    }

    public static List<ClaimedChunk2> getChunksInRadius(Chunk center, double radius) {
        return ChunkUtil.getChunksInRadius(center, (int)Math.ceil(radius));
    }

    public static List<ClaimedChunk2> getChunksInRadius(Chunk center, int radius) {
        return ChunkUtil.getChunksInRadius(NewClaimedChunkStorage.getInstance().get(center), radius);
    }

    public static List<ClaimedChunk2> getChunksInRadius(ClaimedChunk2 center, double radius) {
        return ChunkUtil.getChunksInRadius(center, (int)Math.ceil(radius));
    }

    public static List<ClaimedChunk2> getChunksInRadius(ClaimedChunk2 center, int radius) {
        ArrayList<ClaimedChunk2> chunksInRadius = new ArrayList<ClaimedChunk2>();
        int centerX = center.getX();
        int centerZ = center.getZ();
        String worldUUID = center.getWorldUUID();
        Vector2D centerPos = new Vector2D(center.getX(), center.getZ(), worldUUID);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                int chunkX = centerX + dx;
                int chunkZ = centerZ + dz;
                ClaimedChunk2 chunk = claimedChunkStorage.get(chunkX, chunkZ, worldUUID);
                if (chunk == null) continue;
                Vector2D vector2D = new Vector2D(chunk.getX(), chunk.getZ(), worldUUID);
                if (!(centerPos.getDistance(vector2D) <= (double)radius)) continue;
                chunksInRadius.add(chunk);
            }
        }
        return chunksInRadius;
    }

    public static boolean isInBufferZone(ClaimedChunk2 chunkToAnalyse, TerritoryData territoryToAllow) {
        List<ClaimedChunk2> claimedChunkToAnalyse = ChunkUtil.getChunksInRadius(chunkToAnalyse, Constants.territoryClaimBufferZone());
        for (ClaimedChunk2 claimedChunk2 : claimedChunkToAnalyse) {
            TerritoryChunk territoryChunk;
            if (!(claimedChunk2 instanceof TerritoryChunk) || territoryToAllow.canAccessBufferZone(territoryChunk = (TerritoryChunk)claimedChunk2)) continue;
            return true;
        }
        return false;
    }
}

