/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.text;

import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;

public class DateUtil {
    private DateUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getDateStringFromMilli(long date) {
        return DateUtil.getDateStringFromSeconds(date / 1000L);
    }

    public static String getDateStringFromSeconds(long date) {
        return DateUtil.getDateStringFromMinutes(date / 60L);
    }

    public static String getDateStringFromMinutes(long date) {
        int nbHours = (int)(date / 60L);
        int nbMinutes = (int)(date % 60L);
        return nbHours + "h" + String.format("%02d", nbMinutes) + "m";
    }

    public static String getRelativeTimeDescription(LangType langType, long date) {
        long diffSeconds = (System.currentTimeMillis() - date) / 1000L;
        if (diffSeconds < 0L) {
            return Lang.RELATIVE_IN_FUTURE.get(langType, new String[0]);
        }
        long minutes = diffSeconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long months = days / 30L;
        long years = days / 365L;
        if (diffSeconds < 60L) {
            return Lang.RELATIVE_TIME_SECOND.get(langType, String.valueOf(diffSeconds));
        }
        if (minutes < 60L) {
            return Lang.RELATIVE_TIME_MINUTE.get(langType, String.valueOf(minutes));
        }
        if (hours < 24L) {
            return Lang.RELATIVE_TIME_HOUR.get(langType, String.valueOf(hours));
        }
        if (days < 7L) {
            return Lang.RELATIVE_TIME_DAY.get(langType, String.valueOf(days));
        }
        if (months < 12L) {
            return Lang.RELATIVE_TIME_MONTH.get(langType, String.valueOf(months));
        }
        return Lang.RELATIVE_TIME_YEAR.get(langType, String.valueOf(years));
    }
}

