/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.utils.text;

import java.util.Random;
import org.leralix.lib.utils.RandomUtil;
import org.leralix.tan.utils.constants.Constants;

public class StringUtil {
    private StringUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isValidColorCode(String colorCode) {
        return colorCode.matches("^[0-9A-Fa-f]{6}$");
    }

    public static int hexColorToInt(String hexColor) {
        return Integer.parseInt(hexColor, 16);
    }

    public static int randomColor() {
        Random random = RandomUtil.getRandom();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        return red << 16 | green << 8 | blue;
    }

    public static String getColoredMoney(double money) {
        String formatedMoney = StringUtil.formatMoney(money);
        if (money > 0.0) {
            return "\u00a7a+" + formatedMoney;
        }
        if (money < 0.0) {
            return "\u00a7c" + formatedMoney;
        }
        return "\u00a77" + formatedMoney;
    }

    public static String formatMoney(double amount) {
        if (amount < 1000.0) {
            return Double.toString(StringUtil.handleDigits(amount));
        }
        if (amount < 1000000.0) {
            return String.format("%.1fK", amount / 1000.0);
        }
        if (amount < 1.0E9) {
            return String.format("%.1fM", amount / 1000000.0);
        }
        if (amount < 1.0E12) {
            return String.format("%.1fB", amount / 1.0E9);
        }
        return String.format("%.1fT", amount / 1.0E12);
    }

    public static double handleDigits(double amount) {
        double digitVal = Math.pow(10.0, Constants.getNbDigits());
        return (double)Math.round(amount * digitVal) / digitVal;
    }
}

