/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.DefenderAcceptDemandsBeforeWarInternalEvent;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.timezone.TimeZoneEnum;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.war.War;
import org.leralix.tan.war.capture.CaptureManager;
import org.leralix.tan.war.info.AttackNotYetStarted;
import org.leralix.tan.war.info.AttackResult;
import org.leralix.tan.war.info.AttackResultCancelled;
import org.leralix.tan.war.legacy.CreateAttackData;
import org.leralix.tan.war.legacy.CurrentAttack;
import org.leralix.tan.war.legacy.WarRole;

public class PlannedAttack {
    private final String ID;
    private String name;
    private final Collection<String> defendersID;
    private final Collection<String> attackersID;
    private AttackResult attackResult;
    final long startTime;
    private final long endTime;
    private final String warID;
    private transient War war;
    private final WarRole warRole;
    private transient BukkitRunnable warStartTask;
    private transient BukkitRunnable warWarningTask;
    boolean isAdminApproved;

    public PlannedAttack(String id, CreateAttackData createAttackData) {
        this.ID = id;
        this.war = createAttackData.getWar();
        this.warID = this.war.getID();
        this.warRole = createAttackData.getAttackingSide();
        this.name = Lang.BASIC_ATTACK_NAME.get(Lang.getServerLang(), this.getWar().getMainAttacker().getName(), this.getWar().getMainDefender().getName());
        this.isAdminApproved = !ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getBoolean("AdminApproval", false);
        this.attackersID = new ArrayList<String>();
        this.attackersID.add(this.getWar().getMainAttackerID());
        this.defendersID = new ArrayList<String>();
        this.defendersID.add(this.getWar().getMainDefenderID());
        this.startTime = new Date().getTime() + (long)createAttackData.getSelectedTime() * 60L * 1000L;
        this.endTime = this.startTime + Constants.getAttackDuration() * 60L * 1000L;
        this.attackResult = new AttackNotYetStarted(this.startTime);
        this.getWar().getMainDefender().addPlannedAttack(this);
        this.getWar().getMainAttacker().addPlannedAttack(this);
        this.setUpStartOfAttack();
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public War getWar() {
        if (this.war == null) {
            this.war = (War)WarStorage.getInstance().get(this.warID);
        }
        return this.war;
    }

    public boolean isAdminApproved() {
        return this.isAdminApproved;
    }

    public void setAdminApproved(boolean isAdminApproved) {
        this.isAdminApproved = isAdminApproved;
    }

    public Collection<ITanPlayer> getDefendingPlayers() {
        ArrayList<ITanPlayer> defenders = new ArrayList<ITanPlayer>();
        for (TerritoryData defendingTerritory : this.getDefendingTerritories()) {
            defenders.addAll(defendingTerritory.getITanPlayerList());
        }
        return defenders;
    }

    public Collection<ITanPlayer> getAttackersPlayers() {
        ArrayList<ITanPlayer> defenders = new ArrayList<ITanPlayer>();
        for (TerritoryData attackingTerritory : this.getAttackingTerritories()) {
            defenders.addAll(attackingTerritory.getITanPlayerList());
        }
        return defenders;
    }

    public Collection<TerritoryData> getDefendingTerritories() {
        ArrayList<TerritoryData> defenders = new ArrayList<TerritoryData>();
        for (String defenderID : this.defendersID) {
            defenders.add(TerritoryUtil.getTerritory(defenderID));
        }
        return defenders;
    }

    public Collection<TerritoryData> getAttackingTerritories() {
        ArrayList<TerritoryData> attackers = new ArrayList<TerritoryData>();
        for (String attackerID : this.attackersID) {
            attackers.add(TerritoryUtil.getTerritory(attackerID));
        }
        return attackers;
    }

    public void broadCastMessageWithSound(FilledLang message, SoundEnum soundEnum) {
        Collection<TerritoryData> territoryData = this.getAttackingTerritories();
        territoryData.addAll(this.getDefendingTerritories());
        for (TerritoryData territory : territoryData) {
            territory.broadcastMessageWithSound(message, soundEnum);
        }
    }

    public void setUpStartOfAttack() {
        long currentTime = new Date().getTime();
        long timeLeftBeforeStart = (long)((double)(this.startTime - currentTime) * 0.02);
        long timeLeftBeforeWarning = timeLeftBeforeStart - 1200L;
        if (timeLeftBeforeStart <= 0L) {
            this.startWar(this.startTime - timeLeftBeforeStart);
            return;
        }
        this.warStartTask = new BukkitRunnable(){

            public void run() {
                PlannedAttack.this.startWar(PlannedAttack.this.startTime);
            }
        };
        this.warStartTask.runTaskLater((Plugin)TownsAndNations.getPlugin(), timeLeftBeforeStart);
        if (timeLeftBeforeWarning > 0L) {
            this.warWarningTask = new BukkitRunnable(){

                public void run() {
                    PlannedAttack.this.broadCastMessageWithSound(Lang.ATTACK_START_IN_1_MINUTES.get(PlannedAttack.this.name), SoundEnum.WAR);
                }
            };
            this.warWarningTask.runTaskLater((Plugin)TownsAndNations.getPlugin(), timeLeftBeforeWarning);
        }
    }

    void startWar(long startTime) {
        this.broadCastMessageWithSound(Lang.ATTACK_START_NOW.get(this.name), SoundEnum.WAR);
        CurrentAttacksStorage.startAttack(this, startTime, this.endTime);
    }

    public void addDefender(TerritoryData territory) {
        this.defendersID.add(territory.getID());
    }

    public void addAttacker(TerritoryData territoryData) {
        this.attackersID.add(territoryData.getID());
    }

    public IconBuilder getAdminIcon(IconManager iconManager, LangType langType, TimeZoneEnum timeZoneEnum) {
        IconBuilder iconBuilder = this.getIcon(iconManager, langType, timeZoneEnum);
        if (this.isAdminApproved) {
            return iconBuilder.addDescription(Lang.ATTACK_ICON_DESC_ADMIN_APPROVED.get());
        }
        return iconBuilder.addDescription(Lang.ATTACK_ICON_DESC_ADMIN_NOT_APPROVED.get(), Lang.LEFT_CLICK_TO_AUTHORIZE.get(), Lang.GUI_GENERIC_RIGHT_CLICK_TO_DELETE.get(), Lang.ATTACK_WILL_NOT_TRIGGER_IF_NOT_APPROVED.get());
    }

    public IconBuilder getIcon(IconManager iconManager, LangType langType, TimeZoneEnum timeZone) {
        return iconManager.get(Material.IRON_SWORD).setName(String.valueOf(ChatColor.GREEN) + this.name).setDescription(Lang.ATTACK_ICON_DESC_1.get(this.getWar().getMainAttacker().getName()), Lang.ATTACK_ICON_DESC_2.get(this.getWar().getMainDefender().getName()), Lang.ATTACK_ICON_DESC_3.get(Integer.toString(this.getNumberOfAttackers())), Lang.ATTACK_ICON_DESC_4.get(Integer.toString(this.getNumberOfDefenders()))).addDescription(this.attackResult.getResultLines(langType, timeZone));
    }

    public IconBuilder getIcon(IconManager iconManager, LangType langType, TimeZoneEnum timeZone, TerritoryData territoryConcerned) {
        return this.getIcon(iconManager, langType, timeZone).addDescription(Lang.ATTACK_ICON_DESC_8.get(this.getTerritoryRole(territoryConcerned).getName(langType)));
    }

    private int getNumberOfAttackers() {
        return this.attackersID.size();
    }

    private int getNumberOfDefenders() {
        return this.defendersID.size();
    }

    public void end(AttackResult attackResult) {
        this.attackResult = attackResult;
        if (this.warStartTask != null) {
            this.warStartTask.cancel();
        }
        if (this.warWarningTask != null) {
            this.warWarningTask.cancel();
        }
        CaptureManager.getInstance().removeCapture(this);
        CurrentAttack currentAttack = CurrentAttacksStorage.get(this.ID);
        if (currentAttack != null) {
            currentAttack.end();
        }
        for (TerritoryData territory : this.getAttackingTerritories()) {
            territory.removePlannedAttack(this);
        }
        for (TerritoryData territory : this.getDefendingTerritories()) {
            territory.removePlannedAttack(this);
        }
    }

    private boolean isSecondaryAttacker(TerritoryData territoryConcerned) {
        return this.attackersID.contains(territoryConcerned.getID());
    }

    private boolean isSecondaryDefender(TerritoryData territoryConcerned) {
        return this.defendersID.contains(territoryConcerned.getID());
    }

    public WarRole getRole(ITanPlayer player) {
        for (TerritoryData territoryData : player.getAllTerritoriesPlayerIsIn()) {
            WarRole role = this.getTerritoryRole(territoryData);
            if (role == WarRole.NEUTRAL) continue;
            return role;
        }
        return WarRole.NEUTRAL;
    }

    public WarRole getTerritoryRole(TerritoryData territory) {
        if (this.getWar().isMainAttacker(territory)) {
            return WarRole.MAIN_ATTACKER;
        }
        if (this.getWar().isMainDefender(territory)) {
            return WarRole.MAIN_DEFENDER;
        }
        if (this.isSecondaryAttacker(territory)) {
            return WarRole.OTHER_ATTACKER;
        }
        if (this.isSecondaryDefender(territory)) {
            return WarRole.OTHER_DEFENDER;
        }
        return WarRole.NEUTRAL;
    }

    public void removeBelligerent(TerritoryData territory) {
        String territoryID = territory.getID();
        this.attackersID.remove(territoryID);
        this.defendersID.remove(territoryID);
    }

    public void territorySurrendered() {
        EventManager.getInstance().callEvent(new DefenderAcceptDemandsBeforeWarInternalEvent(this.getWar().getMainDefender(), this.getWar().getMainAttacker()));
        this.getWar().territorySurrender(this.warRole);
        this.end(new AttackResultCancelled());
    }

    public ItemStack getAttackingIcon(LangType langType) {
        ItemStack itemStack = new ItemStack(Material.IRON_HELMET);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.setDisplayName(Lang.GUI_ATTACKING_SIDE_ICON.get(langType, new String[0]));
        lore.add(Lang.GUI_ATTACKING_SIDE_ICON_DESC1.get(langType, new String[0]));
        for (TerritoryData territoryData : this.getAttackingTerritories()) {
            lore.add(Lang.GUI_ICON_LIST.get(langType, territoryData.getBaseColoredName()));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack getDefendingIcon(LangType langType) {
        ItemStack itemStack = new ItemStack(Material.DIAMOND_HELMET);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.setDisplayName(Lang.GUI_DEFENDING_SIDE_ICON.get(langType, new String[0]));
        lore.add(Lang.GUI_DEFENDING_SIDE_ICON_DESC1.get(langType, new String[0]));
        for (TerritoryData territoryData : this.getDefendingTerritories()) {
            lore.add(Lang.GUI_ICON_LIST.get(langType, territoryData.getBaseColoredName()));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public void rename(String message) {
        this.name = message;
    }

    public List<OfflinePlayer> getAllOfflinePlayers() {
        ArrayList<ITanPlayer> res = new ArrayList<ITanPlayer>(this.getDefendingPlayers());
        res.addAll(this.getAttackersPlayers());
        return res.stream().map(ITanPlayer::getOfflinePlayer).filter(Objects::nonNull).toList();
    }

    public List<Player> getAllOnlinePlayers() {
        return this.getAllOfflinePlayers().stream().map(OfflinePlayer::getPlayer).filter(Objects::nonNull).toList();
    }
}

