/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.info.AttackResultCancelled;
import org.leralix.tan.war.legacy.CreateAttackData;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class War {
    private final String ID;
    private String name;
    private final String mainDefenderID;
    private final String mainAttackerID;
    private final List<WarGoal> attackGoals;
    private final List<WarGoal> defenseGoals;
    private HashMap<String, PlannedAttack> plannedAttacks;

    public War(String id, TerritoryData mainAttacker, TerritoryData mainDefender) {
        this.ID = id;
        this.name = "War " + id;
        this.mainDefenderID = mainDefender.getID();
        this.mainAttackerID = mainAttacker.getID();
        this.attackGoals = new ArrayList<WarGoal>();
        this.defenseGoals = new ArrayList<WarGoal>();
        this.plannedAttacks = new HashMap();
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMainDefenderID() {
        return this.mainDefenderID;
    }

    public TerritoryData getMainDefender() {
        return TerritoryUtil.getTerritory(this.mainDefenderID);
    }

    public String getMainAttackerID() {
        return this.mainAttackerID;
    }

    public TerritoryData getMainAttacker() {
        return TerritoryUtil.getTerritory(this.mainAttackerID);
    }

    public boolean isMainAttacker(TerritoryData territoryData) {
        return territoryData.getID().equals(this.mainAttackerID);
    }

    public boolean isMainDefender(TerritoryData territoryData) {
        return territoryData.getID().equals(this.mainDefenderID);
    }

    public ItemStack getIcon() {
        return new ItemStack(Material.IRON_SWORD);
    }

    public void territorySurrender(WarRole looserTerritory) {
        TerritoryData looser = this.getTerritory(looserTerritory);
        TerritoryData winner = this.getTerritory(looserTerritory.opposite());
        for (WarGoal goal : this.getGoals(looserTerritory.opposite())) {
            goal.applyWarGoal(winner, looser);
        }
        this.endWar();
    }

    public void endWar() {
        this.getMainAttacker().setRelation(this.getMainDefender(), TownRelation.NEUTRAL);
        for (PlannedAttack plannedAttack : this.getPlannedAttacks()) {
            plannedAttack.end(new AttackResultCancelled());
        }
        WarStorage.getInstance().remove(this);
    }

    public Collection<PlannedAttack> getPlannedAttacks() {
        return this.getPlannedAttacksMap().values();
    }

    public Map<String, PlannedAttack> getPlannedAttacksMap() {
        if (this.plannedAttacks == null) {
            this.plannedAttacks = new HashMap();
        }
        return this.plannedAttacks;
    }

    public List<WarGoal> getGoals(WarRole warRole) {
        if (warRole == WarRole.MAIN_ATTACKER) {
            return this.attackGoals;
        }
        if (warRole == WarRole.MAIN_DEFENDER) {
            return this.defenseGoals;
        }
        return Collections.emptyList();
    }

    public void removeGoal(WarRole warRole, WarGoal goal) {
        if (warRole == WarRole.MAIN_ATTACKER) {
            this.attackGoals.remove(goal);
        } else if (warRole == WarRole.MAIN_DEFENDER) {
            this.defenseGoals.remove(goal);
        }
    }

    public void addGoal(WarRole warRole, WarGoal conquerWarGoal) {
        if (warRole == WarRole.MAIN_ATTACKER) {
            this.attackGoals.add(conquerWarGoal);
        } else if (warRole == WarRole.MAIN_DEFENDER) {
            this.defenseGoals.add(conquerWarGoal);
        }
    }

    public TerritoryData getTerritory(WarRole warRole) {
        if (warRole == WarRole.MAIN_ATTACKER) {
            return this.getMainAttacker();
        }
        if (warRole == WarRole.MAIN_DEFENDER) {
            return this.getMainDefender();
        }
        throw new IllegalArgumentException(String.valueOf((Object)warRole) + " is not authorized");
    }

    public Collection<FilledLang> generateWarGoalsDesciption(WarRole warRole, LangType langType) {
        List<WarGoal> goals = this.getGoals(warRole.opposite());
        ArrayList<FilledLang> goalsToString = new ArrayList<FilledLang>();
        for (WarGoal goal : goals) {
            goalsToString.add(Lang.WAR_GOAL_LIST_BUTTON_LIST.get(goal.getCurrentDesc(langType)));
        }
        if (goalsToString.isEmpty()) {
            goalsToString.add(Lang.WAR_GOAL_LIST_BUTTON_LIST_NO_WAR_GOAL_SET.get());
        }
        return goalsToString;
    }

    public PlannedAttack addAttack(CreateAttackData createAttackData) {
        String newID = this.getNextID();
        PlannedAttack newPlannedAttack = new PlannedAttack(newID, createAttackData);
        this.getPlannedAttacksMap().put(newID, newPlannedAttack);
        return newPlannedAttack;
    }

    private String getNextID() {
        int ID = 0;
        while (this.getPlannedAttacksMap().containsKey(this.getID() + "_" + ID)) {
            ++ID;
        }
        return this.getID() + "_" + ID;
    }
}

