/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.capture;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.legacy.CurrentAttack;

public class CaptureChunk {
    private final TerritoryChunk territoryChunk;
    private int score;
    private final int maxScore = 100;
    private final CurrentAttack currentAttack;
    private final List<Player> attackers;
    private final List<Player> defenders;

    public CaptureChunk(int initialScore, TerritoryChunk territoryChunk, CurrentAttack currentAttack) {
        this.score = initialScore;
        this.attackers = new ArrayList<Player>();
        this.defenders = new ArrayList<Player>();
        this.territoryChunk = territoryChunk;
        this.currentAttack = currentAttack;
    }

    public boolean isCaptured() {
        return this.score >= 100;
    }

    public boolean isLiberated() {
        return this.score <= 0;
    }

    public void addAttacker(Player player) {
        this.attackers.add(player);
    }

    public void addDefender(Player player) {
        this.defenders.add(player);
    }

    public void update() {
        Optional<Fort> fortProtectingChunk = this.getFortProtecting();
        if (fortProtectingChunk.isEmpty()) {
            this.updateScore();
        }
        String message = this.generateMessage(fortProtectingChunk);
        ArrayList<Player> allPlayers = new ArrayList<Player>(this.attackers);
        allPlayers.addAll(this.defenders);
        for (Player player : allPlayers) {
            if (player == null || !player.isOnline() || player.getPlayer() == null) continue;
            player.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
        }
    }

    public String getWarID() {
        return this.currentAttack.getAttackData().getWar().getID();
    }

    private Optional<Fort> getFortProtecting() {
        for (Fort fort : this.territoryChunk.getOccupier().getAllControlledFort()) {
            if (!(fort.getPosition().getDistance(this.territoryChunk.getMiddleVector2D()) <= Constants.getFortProtectionRadius())) continue;
            return Optional.of(fort);
        }
        return Optional.empty();
    }

    private String generateMessage(Optional<Fort> fortProtectingChunk) {
        String nbDefenders = Integer.toString(this.defenders.size());
        String nbAttackers = Integer.toString(this.attackers.size());
        String message = fortProtectingChunk.isPresent() ? Lang.WAR_INFO_CHUNK_PROTECTED.get(Lang.getServerLang(), fortProtectingChunk.get().getPosition().toString(), nbAttackers, nbDefenders) : (this.defenders.size() == this.attackers.size() ? Lang.WAR_INFO_CONTESTED.get(Lang.getServerLang(), Integer.toString(this.score), nbAttackers, nbDefenders) : (this.isCaptured() ? Lang.WAR_INFO_CHUNK_CAPTURED.get(Lang.getServerLang(), this.territoryChunk.getOccupier().getColoredName(), nbAttackers, nbDefenders) : (this.isLiberated() ? Lang.WAR_INFO_CHUNK_OWNED.get(Lang.getServerLang(), nbAttackers, nbDefenders) : Lang.WAR_INFO_CONTESTED.get(Lang.getServerLang(), Integer.toString(this.score), nbAttackers, nbDefenders))));
        return message;
    }

    private void updateScore() {
        if (this.attackers.size() > this.defenders.size()) {
            this.score += 10;
        } else if (this.defenders.size() > this.attackers.size()) {
            this.score -= 10;
        }
        if (this.score < 0) {
            this.score = 0;
            this.territoryChunk.liberate();
            this.currentAttack.getAttackResultCounter().incrementClaimsCaptured();
        } else if (this.score > 100) {
            this.score = 100;
            this.territoryChunk.setOccupier(this.currentAttack.getAttackData().getWar().getMainAttacker());
            this.currentAttack.getAttackResultCounter().decrementClaimsCaptured();
        }
    }

    public void resetPlayers() {
        this.attackers.clear();
        this.defenders.clear();
    }

    public void warOver() {
        this.resetPlayers();
        this.territoryChunk.liberate();
    }
}

