/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.capture;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.legacy.CurrentAttack;

public class CaptureFort {
    private final Fort fort;
    private final CurrentAttack currentAttack;
    private String title;
    private int score;
    private final int maxScore = 60;
    private final List<Player> attackers;
    private final List<Player> defenders;
    private final BossBar bossBar;

    public CaptureFort(Fort fort, CurrentAttack currentAttack) {
        this.fort = fort;
        this.score = 0;
        this.currentAttack = currentAttack;
        this.attackers = new ArrayList<Player>();
        this.defenders = new ArrayList<Player>();
        this.updateTitle(0, 0);
        this.bossBar = Bukkit.createBossBar((String)this.title, (BarColor)BarColor.RED, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
    }

    private void updateTitle(int nbAttackers, int nbDefenders) {
        this.title = Lang.WAR_INFO_FORT_STATUS.get(Lang.getServerLang(), this.fort.getName(), Integer.toString(nbAttackers), Integer.toString(nbDefenders));
    }

    public Fort getFort() {
        return this.fort;
    }

    public void clearPlayers() {
        this.attackers.clear();
        this.defenders.clear();
    }

    public void addAttacker(Player player) {
        this.attackers.add(player);
    }

    public void addDefender(Player player) {
        this.defenders.add(player);
    }

    public void update() {
        int nbDefenders;
        int nbAttackers = this.attackers.size();
        if (nbAttackers > (nbDefenders = this.defenders.size())) {
            ++this.score;
        } else if (nbDefenders > nbAttackers) {
            --this.score;
        }
        if (this.score > 60) {
            this.score = 60;
            this.fort.setOccupier(this.currentAttack.getAttackData().getWar().getMainAttacker());
            this.fort.updateFlag();
            this.currentAttack.getAttackResultCounter().incrementFortsCaptured();
        } else if (this.score < 0) {
            this.score = 0;
            this.fort.liberate();
            this.fort.updateFlag();
            this.currentAttack.getAttackResultCounter().decrementFortsCaptured();
        }
        this.updateBossBar(nbAttackers, nbDefenders);
    }

    private void updateBossBar(int nbAttackers, int nbDefenders) {
        this.bossBar.removeAll();
        this.updateTitle(nbAttackers, nbDefenders);
        this.bossBar.setTitle(this.title);
        this.bossBar.setProgress((double)this.score / 60.0);
        ArrayList<Player> allPlayers = new ArrayList<Player>(this.attackers);
        allPlayers.addAll(this.defenders);
        for (Player player : allPlayers) {
            this.bossBar.addPlayer(player);
        }
    }

    public void warOver() {
        this.bossBar.removeAll();
        this.fort.liberate();
    }

    public String getWarID() {
        return this.currentAttack.getAttackData().getWar().getID();
    }
}

