/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.capture;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;
import org.leralix.lib.position.Vector3D;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.capture.CaptureChunk;
import org.leralix.tan.war.capture.CaptureFort;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.legacy.CurrentAttack;

public class CaptureManager {
    private final Map<TerritoryChunk, CaptureChunk> captures = new HashMap<TerritoryChunk, CaptureChunk>();
    private final Map<String, CaptureFort> forts = new HashMap<String, CaptureFort>();
    private static CaptureManager instance;

    public static CaptureManager getInstance() {
        if (instance == null) {
            instance = new CaptureManager();
        }
        return instance;
    }

    public void updateCapture(CurrentAttack currentAttack) {
        this.handleFortCapture(currentAttack);
        this.handleChunkCapture(currentAttack);
    }

    private void handleFortCapture(CurrentAttack currentAttack) {
        PlannedAttack attackData = currentAttack.getAttackData();
        for (Fort fortAtWar : attackData.getWar().getMainDefender().getOwnedForts()) {
            this.forts.putIfAbsent(fortAtWar.getID(), new CaptureFort(fortAtWar, currentAttack));
        }
        this.registerPlayer(attackData.getAttackersPlayers(), this.forts, CaptureFort::addAttacker);
        this.registerPlayer(attackData.getDefendingPlayers(), this.forts, CaptureFort::addDefender);
        for (CaptureFort captureFort : this.forts.values()) {
            captureFort.update();
        }
        for (CaptureFort captureFort : this.forts.values()) {
            captureFort.clearPlayers();
        }
    }

    private void registerPlayer(Collection<ITanPlayer> players, Map<String, CaptureFort> forts, BiConsumer<CaptureFort, Player> consumer) {
        for (ITanPlayer tanPlayer : players) {
            Player player = tanPlayer.getPlayer();
            if (player == null || !player.isOnline()) continue;
            Vector3D playerPosition = new Vector3D(player.getLocation());
            for (CaptureFort captureFort : forts.values()) {
                if (!(captureFort.getFort().getPosition().getDistance(playerPosition) < Constants.getFortCaptureRadius())) continue;
                consumer.accept(captureFort, player);
            }
        }
    }

    private void handleChunkCapture(CurrentAttack currentAttack) {
        TerritoryChunk territoryChunk;
        ClaimedChunk2 claimedChunk;
        Player player;
        PlannedAttack attackData = currentAttack.getAttackData();
        for (CaptureChunk captureChunk : this.captures.values()) {
            captureChunk.resetPlayers();
        }
        Collection<ITanPlayer> attackers = attackData.getAttackersPlayers();
        Collection<ITanPlayer> defenders = attackData.getDefendingPlayers();
        TerritoryData mainAttacker = attackData.getWar().getMainAttacker();
        for (ITanPlayer attacker : attackers) {
            player = attacker.getPlayer();
            if (player == null || !player.isOnline() || !((claimedChunk = NewClaimedChunkStorage.getInstance().get(player.getLocation().getChunk())) instanceof TerritoryChunk) || !this.canBeCaptured(territoryChunk = (TerritoryChunk)claimedChunk, attackData.getWar().getMainAttacker(), attackData.getWar().getMainDefender())) continue;
            if (!this.captures.containsKey(territoryChunk)) {
                this.captures.putIfAbsent(territoryChunk, new CaptureChunk(0, territoryChunk, currentAttack));
            }
            this.captures.get(territoryChunk).addAttacker(attacker.getPlayer());
        }
        for (ITanPlayer defender : defenders) {
            player = defender.getPlayer();
            if (player == null || !player.isOnline() || !((claimedChunk = NewClaimedChunkStorage.getInstance().get(player.getLocation().getChunk())) instanceof TerritoryChunk) || !this.canBeCaptured(territoryChunk = (TerritoryChunk)claimedChunk, attackData.getWar().getMainAttacker(), attackData.getWar().getMainDefender())) continue;
            if (!this.captures.containsKey(territoryChunk)) {
                this.captures.putIfAbsent(territoryChunk, new CaptureChunk(100, territoryChunk, currentAttack));
            }
            this.captures.get(territoryChunk).addDefender(defender.getPlayer());
        }
        for (CaptureChunk captureChunk : this.captures.values()) {
            captureChunk.update();
        }
    }

    private boolean canBeCaptured(TerritoryChunk territoryChunk, TerritoryData mainAttacker, TerritoryData mainDefender) {
        String ownerID = territoryChunk.getOwnerID();
        String occupierID = territoryChunk.getOccupierID();
        String defenderID = mainDefender.getID();
        String attackerID = mainAttacker.getID();
        if (ownerID.equals(attackerID) && occupierID.equals(defenderID)) {
            return true;
        }
        if (!ownerID.equals(defenderID)) {
            return false;
        }
        boolean surroundedBySame = NewClaimedChunkStorage.getInstance().isAllAdjacentChunksClaimedBySameTerritory(territoryChunk.getChunk(), defenderID);
        return !surroundedBySame;
    }

    public void removeCapture(PlannedAttack plannedAttack) {
        String warID = plannedAttack.getID();
        Iterator<CaptureChunk> captureChunkIterator = this.captures.values().iterator();
        while (captureChunkIterator.hasNext()) {
            CaptureChunk captureChunk = captureChunkIterator.next();
            if (!captureChunk.getWarID().equals(warID)) continue;
            captureChunk.warOver();
            captureChunkIterator.remove();
        }
        Iterator<CaptureFort> captureFortIterator = this.forts.values().iterator();
        while (captureFortIterator.hasNext()) {
            CaptureFort captureFort = captureFortIterator.next();
            if (!captureFort.getWarID().equals(warID)) continue;
            captureFort.warOver();
            captureFortIterator.remove();
        }
        TerritoryData mainAttacker = plannedAttack.getWar().getMainAttacker();
        TerritoryData mainDefender = plannedAttack.getWar().getMainDefender();
        for (TerritoryChunk territoryChunk : NewClaimedChunkStorage.getInstance().getAllChunkFrom(mainAttacker)) {
            if (!territoryChunk.isOccupied() || !territoryChunk.getOccupierID().equals(mainDefender.getID())) continue;
            territoryChunk.liberate();
        }
        for (TerritoryChunk territoryChunk : NewClaimedChunkStorage.getInstance().getAllChunkFrom(mainDefender)) {
            if (!territoryChunk.isOccupied() || !territoryChunk.getOccupierID().equals(mainAttacker.getID())) continue;
            territoryChunk.liberate();
        }
    }
}

