/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.info;

import java.time.Instant;
import java.util.List;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.timezone.TimeZoneEnum;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.war.info.AttackResult;

public class AttackResultCompleted
extends AttackResult {
    private final long endDateTime = System.currentTimeMillis();
    private final int nbDeathsAttacker;
    private final int nbDeathsDefender;
    private final int nbFortsCaptured;
    private final int nbChunkCaptured;

    public AttackResultCompleted(int nbAttackersKilled, int nbDefendersKilled, int nbFortsCaptured, int nbClaimsCaptured) {
        this.nbDeathsAttacker = nbAttackersKilled;
        this.nbDeathsDefender = nbDefendersKilled;
        this.nbFortsCaptured = nbFortsCaptured;
        this.nbChunkCaptured = nbClaimsCaptured;
    }

    @Override
    public List<FilledLang> getResultLines(LangType langType, TimeZoneEnum timeZone) {
        FilledLang exactTimeStart = TimeZoneManager.getInstance().formatDate(Instant.ofEpochMilli(this.endDateTime), timeZone, langType.getLocale());
        return List.of(Lang.ATTACK_ICON_FINISHED.get(), Lang.ATTACK_ICON_FINISHED_DATE.get(exactTimeStart.get(langType)), Lang.ATTACK_ICON_FINISHED_NB_DEATH_ATTACKERS.get(Integer.toString(this.nbDeathsAttacker)), Lang.ATTACK_ICON_FINISHED_NB_DEATH_DEFENDERS.get(Integer.toString(this.nbDeathsDefender)), Lang.ATTACK_ICON_FINISHED_NB_CHUNK_CAPTURED.get(Integer.toString(this.nbFortsCaptured)), Lang.ATTACK_ICON_FINISHED_NB_FORTS_CAPTURED.get(Integer.toString(this.nbChunkCaptured)));
    }
}

