/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.war.legacy;

import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.utils.gameplay.CommandExecutor;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.cosmetic.ShowBoundaries;
import org.leralix.tan.war.info.AttackResultCounter;

public class CurrentAttack {
    private final PlannedAttack attackData;
    private boolean end;
    private final long totalTime;
    private long remaining;
    private final BossBar bossBar;
    private final AttackResultCounter attackResultCounter;

    public CurrentAttack(PlannedAttack plannedAttack, long startTime, long endTime) {
        this.attackData = plannedAttack;
        this.attackResultCounter = new AttackResultCounter();
        this.end = false;
        this.remaining = this.totalTime = (endTime - startTime) / 50L;
        this.bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.applyBossBar(plannedAttack);
        CommandExecutor.applyStartAttackCommands(this.getAttackData());
        this.start();
    }

    public AttackResultCounter getAttackResultCounter() {
        return this.attackResultCounter;
    }

    private void applyBossBar(PlannedAttack plannedAttack) {
        Player player;
        for (TerritoryData territoryData : plannedAttack.getAttackingTerritories()) {
            for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                tanPlayer.addWar(this);
                player = tanPlayer.getPlayer();
                if (player == null) continue;
                this.bossBar.addPlayer(player);
            }
        }
        for (TerritoryData territoryData : plannedAttack.getDefendingTerritories()) {
            for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                tanPlayer.addWar(this);
                player = tanPlayer.getPlayer();
                if (player == null) continue;
                this.bossBar.addPlayer(player);
            }
        }
    }

    private void updateBossBar() {
        long hours = this.remaining / 72000L;
        long minutes = this.remaining % 72000L / 1200L;
        long seconds = this.remaining % 1200L / 20L;
        String timeString = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        this.bossBar.setTitle(timeString);
        this.bossBar.setProgress((double)(this.totalTime - this.remaining) / (double)this.totalTime);
    }

    public void addPlayer(ITanPlayer tanPlayer) {
        Player player = tanPlayer.getPlayer();
        if (player != null && this.remaining > 0L) {
            this.bossBar.addPlayer(player);
        }
    }

    private void start() {
        BukkitRunnable timerTask = new BukkitRunnable(){

            public void run() {
                if (CurrentAttack.this.remaining > 0L && !CurrentAttack.this.end) {
                    --CurrentAttack.this.remaining;
                    CurrentAttack.this.updateBossBar();
                } else {
                    CurrentAttack.this.end();
                    this.cancel();
                }
            }
        };
        timerTask.runTaskTimer((Plugin)TownsAndNations.getPlugin(), 0L, 1L);
    }

    public void end() {
        if (this.end) {
            return;
        }
        CommandExecutor.applyEndWarCommands(this.getAttackData());
        this.end = true;
        this.attackData.end(this.attackResultCounter.buildResult());
        new BukkitRunnable(){

            public void run() {
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getAttackingTerritories()) {
                    for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                        tanPlayer.removeWar(CurrentAttack.this);
                    }
                }
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getDefendingTerritories()) {
                    for (ITanPlayer tanPlayer : territoryData.getITanPlayerList()) {
                        tanPlayer.removeWar(CurrentAttack.this);
                    }
                }
                CurrentAttack.this.bossBar.removeAll();
                CurrentAttacksStorage.remove(CurrentAttack.this);
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getAttackingTerritories()) {
                    territoryData.removeCurrentAttack(CurrentAttack.this);
                }
                for (TerritoryData territoryData : CurrentAttack.this.attackData.getDefendingTerritories()) {
                    territoryData.removeCurrentAttack(CurrentAttack.this);
                }
            }
        }.runTaskLater((Plugin)TownsAndNations.getPlugin(), 400L);
    }

    public boolean containsPlayer(ITanPlayer tanPlayer) {
        for (TerritoryData territoryData : this.attackData.getAttackingTerritories()) {
            if (!territoryData.isPlayerIn(tanPlayer)) continue;
            return true;
        }
        for (TerritoryData territoryData : this.attackData.getDefendingTerritories()) {
            if (!territoryData.isPlayerIn(tanPlayer)) continue;
            return true;
        }
        return false;
    }

    public PlannedAttack getAttackData() {
        return this.attackData;
    }

    public void displayBoundaries() {
        for (Player player : this.attackData.getAllOnlinePlayers()) {
            if (player == null) continue;
            ShowBoundaries.display(player);
        }
    }
}

