/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.xdevapi;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.leralix.shadow.mysql.cj.Messages;
import org.leralix.shadow.mysql.cj.MysqlxSession;
import org.leralix.shadow.mysql.cj.conf.ConnectionUrl;
import org.leralix.shadow.mysql.cj.conf.DefaultPropertySet;
import org.leralix.shadow.mysql.cj.conf.HostInfo;
import org.leralix.shadow.mysql.cj.conf.PropertyDefinitions;
import org.leralix.shadow.mysql.cj.conf.PropertyKey;
import org.leralix.shadow.mysql.cj.conf.PropertySet;
import org.leralix.shadow.mysql.cj.conf.RuntimeProperty;
import org.leralix.shadow.mysql.cj.protocol.x.XMessageBuilder;
import org.leralix.shadow.mysql.cj.protocol.x.XProtocol;
import org.leralix.shadow.mysql.cj.protocol.x.XProtocolError;
import org.leralix.shadow.mysql.cj.result.Row;
import org.leralix.shadow.mysql.cj.result.StringValueFactory;
import org.leralix.shadow.mysql.cj.util.StringUtils;
import org.leralix.shadow.mysql.cj.xdevapi.Schema;
import org.leralix.shadow.mysql.cj.xdevapi.SchemaImpl;
import org.leralix.shadow.mysql.cj.xdevapi.Session;
import org.leralix.shadow.mysql.cj.xdevapi.SqlStatementImpl;
import org.leralix.shadow.mysql.cj.xdevapi.UpdateResultBuilder;
import org.leralix.shadow.mysql.cj.xdevapi.XDevAPIError;

public class SessionImpl
implements Session {
    protected MysqlxSession session;
    protected String defaultSchemaName;
    private XMessageBuilder xbuilder;

    public SessionImpl(HostInfo hostInfo) {
        DefaultPropertySet pset = new DefaultPropertySet();
        pset.initializeProperties(hostInfo.exposeAsProperties());
        this.session = new MysqlxSession(hostInfo, pset);
        this.defaultSchemaName = hostInfo.getDatabase();
        this.xbuilder = (XMessageBuilder)this.session.getMessageBuilder();
    }

    public SessionImpl(XProtocol prot) {
        this.session = new MysqlxSession(prot);
        this.defaultSchemaName = prot.defaultSchemaName;
        this.xbuilder = (XMessageBuilder)this.session.getMessageBuilder();
    }

    protected SessionImpl() {
    }

    @Override
    public List<Schema> getSchemas() {
        Function<Row, String> rowToName = r -> r.getValue(0, new StringValueFactory(this.session.getPropertySet()));
        Function<Row, Schema> rowToSchema = rowToName.andThen(n -> new SchemaImpl(this.session, this, (String)n));
        return this.session.query(this.xbuilder.buildSqlStatement("select schema_name from information_schema.schemata"), null, rowToSchema, Collectors.toList());
    }

    @Override
    public Schema getSchema(String schemaName) {
        return new SchemaImpl(this.session, this, schemaName);
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public Schema getDefaultSchema() {
        if (this.defaultSchemaName == null || this.defaultSchemaName.length() == 0) {
            return null;
        }
        return new SchemaImpl(this.session, this, this.defaultSchemaName);
    }

    @Override
    public Schema createSchema(String schemaName) {
        StringBuilder stmtString = new StringBuilder("CREATE DATABASE ");
        stmtString.append(StringUtils.quoteIdentifier(schemaName, true));
        this.session.query(this.xbuilder.buildSqlStatement(stmtString.toString()), new UpdateResultBuilder());
        return this.getSchema(schemaName);
    }

    @Override
    public Schema createSchema(String schemaName, boolean reuseExistingObject) {
        try {
            return this.createSchema(schemaName);
        }
        catch (XProtocolError ex) {
            if (ex.getErrorCode() == 1007) {
                return this.getSchema(schemaName);
            }
            throw ex;
        }
    }

    @Override
    public void dropSchema(String schemaName) {
        StringBuilder stmtString = new StringBuilder("DROP DATABASE ");
        stmtString.append(StringUtils.quoteIdentifier(schemaName, true));
        this.session.query(this.xbuilder.buildSqlStatement(stmtString.toString()), new UpdateResultBuilder());
    }

    @Override
    public void startTransaction() {
        this.session.query(this.xbuilder.buildSqlStatement("START TRANSACTION"), new UpdateResultBuilder());
    }

    @Override
    public void commit() {
        this.session.query(this.xbuilder.buildSqlStatement("COMMIT"), new UpdateResultBuilder());
    }

    @Override
    public void rollback() {
        this.session.query(this.xbuilder.buildSqlStatement("ROLLBACK"), new UpdateResultBuilder());
    }

    @Override
    public String setSavepoint() {
        return this.setSavepoint(StringUtils.getUniqueSavepointId());
    }

    @Override
    public String setSavepoint(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new XDevAPIError(Messages.getString("XSession.0", new String[]{"name"}));
        }
        this.session.query(this.xbuilder.buildSqlStatement("SAVEPOINT " + StringUtils.quoteIdentifier(name, true)), new UpdateResultBuilder());
        return name;
    }

    @Override
    public void rollbackTo(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new XDevAPIError(Messages.getString("XSession.0", new String[]{"name"}));
        }
        this.session.query(this.xbuilder.buildSqlStatement("ROLLBACK TO " + StringUtils.quoteIdentifier(name, true)), new UpdateResultBuilder());
    }

    @Override
    public void releaseSavepoint(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new XDevAPIError(Messages.getString("XSession.0", new String[]{"name"}));
        }
        this.session.query(this.xbuilder.buildSqlStatement("RELEASE SAVEPOINT " + StringUtils.quoteIdentifier(name, true)), new UpdateResultBuilder());
    }

    @Override
    public String getUri() {
        PropertySet pset = this.session.getPropertySet();
        StringBuilder sb = new StringBuilder(ConnectionUrl.Type.XDEVAPI_SESSION.getScheme());
        sb.append("//").append(this.session.getProcessHost()).append(":").append(this.session.getPort()).append("/").append(this.defaultSchemaName).append("?");
        boolean isFirstParam = true;
        for (PropertyKey propKey : PropertyDefinitions.PROPERTY_KEY_TO_PROPERTY_DEFINITION.keySet()) {
            RuntimeProperty propToGet = pset.getProperty(propKey);
            if (!propToGet.isExplicitlySet()) continue;
            String propValue = propToGet.getStringValue();
            Object defaultValue = propToGet.getPropertyDefinition().getDefaultValue();
            if (!(defaultValue == null && !StringUtils.isNullOrEmpty(propValue) || defaultValue != null && propValue == null) && (defaultValue == null || propValue == null || propValue.equals(defaultValue.toString()))) continue;
            if (isFirstParam) {
                isFirstParam = false;
            } else {
                sb.append("&");
            }
            sb.append(propKey.getKeyName());
            sb.append("=");
            sb.append(propValue);
        }
        return sb.toString();
    }

    @Override
    public boolean isOpen() {
        return !this.session.isClosed();
    }

    @Override
    public void close() {
        this.session.quit();
    }

    @Override
    public SqlStatementImpl sql(String sql) {
        return new SqlStatementImpl(this.session, sql);
    }

    public MysqlxSession getSession() {
        return this.session;
    }
}

