/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.external.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.leralix.tan.enums.permissions.ChunkPermissionType;

public class WorldGuardImplementation {
    public boolean isActionAllowed(Player player, Location location, ChunkPermissionType actionType) {
        StateFlag flag = this.getFlagForAction(actionType);
        com.sk89q.worldedit.util.Location weLocation = BukkitAdapter.adapt((Location)location);
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet regionSet = query.getApplicableRegions(weLocation);
        for (ProtectedRegion region : regionSet) {
            if (!region.isOwner(localPlayer)) continue;
            return true;
        }
        boolean hasExplicitFlag = false;
        for (ProtectedRegion region : regionSet) {
            StateFlag.State state = (StateFlag.State)region.getFlag((Flag)flag);
            if (state == null) continue;
            hasExplicitFlag = true;
            if (state != StateFlag.State.ALLOW) continue;
            return true;
        }
        return !hasExplicitFlag;
    }

    public boolean isHandledByWorldGuard(Location location) {
        com.sk89q.worldedit.util.Location weLocation = BukkitAdapter.adapt((Location)location);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet regionSet = query.getApplicableRegions(weLocation);
        return regionSet.size() > 0;
    }

    private StateFlag getFlagForAction(ChunkPermissionType actionType) {
        return switch (actionType) {
            default -> throw new MatchException(null, null);
            case ChunkPermissionType.BREAK_BLOCK -> Flags.BLOCK_BREAK;
            case ChunkPermissionType.PLACE_BLOCK -> Flags.BLOCK_PLACE;
            case ChunkPermissionType.ATTACK_PASSIVE_MOB -> Flags.DAMAGE_ANIMALS;
            case ChunkPermissionType.INTERACT_BERRIES, ChunkPermissionType.INTERACT_BUTTON, ChunkPermissionType.INTERACT_ARMOR_STAND, ChunkPermissionType.INTERACT_DOOR, ChunkPermissionType.INTERACT_DECORATIVE_BLOCK, ChunkPermissionType.INTERACT_ITEM_FRAME, ChunkPermissionType.INTERACT_MUSIC_BLOCK, ChunkPermissionType.INTERACT_REDSTONE, ChunkPermissionType.USE_LEAD, ChunkPermissionType.USE_BONE_MEAL, ChunkPermissionType.USE_SHEARS -> Flags.INTERACT;
            case ChunkPermissionType.INTERACT_CHEST, ChunkPermissionType.INTERACT_FURNACE -> Flags.CHEST_ACCESS;
            case ChunkPermissionType.INTERACT_BOAT, ChunkPermissionType.INTERACT_MINECART -> Flags.PLACE_VEHICLE;
        };
    }
}

