/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.internal.wrappers;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.tan.api.enums.EChunkPermission;
import org.tan.api.interfaces.TanClaimedChunk;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanRegion;
import org.tan.api.interfaces.TanTerritory;
import org.tan.api.interfaces.TanTown;

public class ClaimedChunkWrapper
implements TanClaimedChunk {
    private final ClaimedChunk2 claimedChunk;

    private ClaimedChunkWrapper(ClaimedChunk2 claimedChunk) {
        this.claimedChunk = claimedChunk;
    }

    public static TanClaimedChunk of(ClaimedChunk2 claimedChunk) {
        if (claimedChunk == null) {
            return null;
        }
        return new ClaimedChunkWrapper(claimedChunk);
    }

    @Override
    public int getX() {
        return this.claimedChunk.getX();
    }

    @Override
    public int getZ() {
        return this.claimedChunk.getZ();
    }

    @Override
    public UUID getWorldUUID() {
        return UUID.fromString(this.claimedChunk.getWorldUUID());
    }

    @Override
    public String getworldName() {
        return this.claimedChunk.getWorld().getName();
    }

    @Override
    public Boolean isClaimed() {
        return this.claimedChunk.isClaimed();
    }

    @Override
    public Optional<UUID> getOwnerID() {
        if (this.claimedChunk.getOwnerID() == null) {
            return Optional.empty();
        }
        return Optional.of(UUID.fromString(this.claimedChunk.getOwnerID()));
    }

    @Override
    public void unclaim() {
        NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(this.claimedChunk);
    }

    @Override
    public boolean canClaim(TanTerritory tanTerritory) {
        TerritoryData territoryData = TerritoryUtil.getTerritory(tanTerritory.getID());
        if (territoryData != null) {
            return this.claimedChunk.canTerritoryClaim(null, territoryData);
        }
        return false;
    }

    @Override
    public void claim(TanTerritory tanTerritory) {
        if (tanTerritory == null) {
            return;
        }
        if (tanTerritory instanceof TanTown) {
            NewClaimedChunkStorage.getInstance().claimTownChunk(this.claimedChunk.getChunk(), tanTerritory.getID());
        }
        if (tanTerritory instanceof TanRegion) {
            NewClaimedChunkStorage.getInstance().claimRegionChunk(this.claimedChunk.getChunk(), tanTerritory.getID());
        }
    }

    @Override
    public boolean canBeGriefByExplosion() {
        return this.claimedChunk.canExplosionGrief();
    }

    @Override
    public boolean canBeGriefByFire() {
        return this.claimedChunk.canFireGrief();
    }

    @Override
    public boolean canPvpHappen() {
        return this.claimedChunk.canPVPHappen();
    }

    @Override
    public boolean canPlayerDoAction(TanPlayer tanPlayer, EChunkPermission permission, Location location) {
        Player player = Bukkit.getPlayer((UUID)tanPlayer.getUUID());
        if (player == null) {
            return false;
        }
        ChunkPermissionType chunkPermissionType = ChunkPermissionType.valueOf(permission.name());
        return this.claimedChunk.canPlayerDo(player, chunkPermissionType, location);
    }
}

