/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class SeeBalanceCommand
extends PlayerSubCommand {
    public String getName() {
        return "balance";
    }

    public String getDescription() {
        return Lang.BAL_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan balance";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length == 1) {
            TanChatUtils.message(player, Lang.BAL_AMOUNT.get(langType, Double.toString(EconomyUtil.getBalance(PlayerDataStorage.getInstance().get(player)))));
        } else if (args.length > 1) {
            TanChatUtils.message(player, Lang.TOO_MANY_ARGS_ERROR.get(langType, new String[0]));
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
        }
    }
}

