/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.TeleportationRegister;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class TownSpawnCommand
extends PlayerSubCommand {
    public String getName() {
        return "spawn";
    }

    public String getDescription() {
        return Lang.SPAWN_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan spawn";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length != 1) {
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        ITanPlayer playerStat = PlayerDataStorage.getInstance().get(player.getUniqueId().toString());
        if (!playerStat.hasTown()) {
            TanChatUtils.message(player, Lang.PLAYER_NO_TOWN.get(langType, new String[0]));
            return;
        }
        TownData townData = TownDataStorage.getInstance().get(player);
        if (townData.isSpawnLocked()) {
            TanChatUtils.message(player, Lang.SPAWN_NOT_UNLOCKED.get(langType, new String[0]));
            return;
        }
        if (!townData.isSpawnSet()) {
            TanChatUtils.message(player, Lang.SPAWN_NOT_SET.get(langType, new String[0]));
            return;
        }
        TeleportationRegister.teleportToTownSpawn(playerStat, townData);
    }
}

