/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.Collections;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.commands.player.MapCommand;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.enums.MapSettings;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class UnclaimCommand
extends PlayerSubCommand {
    public String getName() {
        return "unclaim";
    }

    public String getDescription() {
        return Lang.UNCLAIM_CHUNK_COMMAND_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan unclaim";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        return Collections.emptyList();
    }

    public void perform(Player player, String[] args) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        if (args.length != 1 && args.length != 4) {
            TanChatUtils.message(player, Lang.SYNTAX_ERROR.get(langType, new String[0]));
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(langType, this.getSyntax()));
            return;
        }
        Chunk chunk = null;
        if (args.length == 1) {
            chunk = player.getLocation().getChunk();
        }
        if (args.length == 4) {
            int x = Integer.parseInt(args[2]);
            int y = Integer.parseInt(args[3]);
            chunk = player.getLocation().getWorld().getChunkAt(x, y);
        }
        if (!NewClaimedChunkStorage.getInstance().isChunkClaimed(chunk)) {
            TanChatUtils.message(player, Lang.CHUNK_NOT_CLAIMED.get(langType, new String[0]));
            return;
        }
        ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(chunk);
        claimedChunk.unclaimChunk(player);
        if (args.length == 4) {
            MapCommand.openMap(player, new MapSettings(args[0], args[1]));
        }
    }
}

