/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.TownUpgrade;
import org.leralix.tan.libs.exp4j.Expression;
import org.leralix.tan.libs.exp4j.ExpressionBuilder;
import org.leralix.tan.storage.legacy.UpgradeStorage;

public class Level {
    private int townLevel;
    Map<String, Integer> levelMap = new HashMap<String, Integer>();

    public Level() {
        this.levelMap.put("townLevel", 1);
        UpgradeStorage.loadIntoMap(this.levelMap);
        this.levelMap.put("CITY_HALL", 1);
    }

    public int getUpgradeLevel(String upgradeName) {
        if (upgradeName.equals("TOWN_LEVEL")) {
            return this.townLevel;
        }
        return this.levelMap.computeIfAbsent(upgradeName, k -> 0);
    }

    public int getTownLevel() {
        return this.townLevel;
    }

    public void townLevelUp() {
        ++this.townLevel;
    }

    public int getPlayerCap() {
        return this.getTotalBenefits().get("PLAYER_CAP");
    }

    public int getChunkCap() {
        return this.getBenefitsLevel("CHUNK_CAP");
    }

    public int getPropertyCap() {
        Integer propertyCap = this.getTotalBenefits().get("PROPERTY_CAP");
        if (propertyCap == null) {
            return 0;
        }
        return propertyCap;
    }

    public boolean isTownSpawnUnlocked() {
        return this.getTotalBenefits().get("TOWN_SPAWN_UNLOCKED") > 1;
    }

    public int getMoneyRequiredForLevelUp() {
        return this.getRequiredMoney(this.getTownLevel());
    }

    private int getRequiredMoney(int level) {
        FileConfiguration fg = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.UPGRADE);
        ConfigurationSection section = fg.getConfigurationSection("townUpgrades");
        String expressionString = section.getString("TownLevelExpression");
        String squareMultName = "squareMultiplier";
        String flatMultName = "flatMultiplier";
        double squareMultiplier = section.getDouble(squareMultName);
        double flatMultiplier = section.getDouble(flatMultName);
        double base = section.getDouble("base");
        Expression expression = new ExpressionBuilder(expressionString).variable("level").variable(squareMultName).variable(flatMultName).variable("base").build().setVariable("level", level).setVariable(squareMultName, squareMultiplier).setVariable(flatMultName, flatMultiplier).setVariable("base", base);
        return (int)expression.evaluate();
    }

    public void levelUp(TownUpgrade townUpgrade) {
        int currentLevel = this.getUpgradeLevel(townUpgrade.getName());
        this.levelMap.put(townUpgrade.getName(), currentLevel + 1);
    }

    public Map<String, Integer> getTotalBenefits() {
        HashMap<String, Integer> benefits = new HashMap<String, Integer>();
        for (TownUpgrade townUpgrade : UpgradeStorage.getUpgrades()) {
            String name = townUpgrade.getName();
            Map<String, Integer> map = townUpgrade.getBenefits();
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String benefitName = entry.getKey();
                Integer benefitValue = entry.getValue() * this.getUpgradeLevel(name);
                if (benefits.containsKey(benefitName)) {
                    benefits.put(benefitName, (Integer)benefits.get(benefitName) + benefitValue);
                    continue;
                }
                benefits.put(benefitName, benefitValue);
            }
        }
        return benefits;
    }

    public int getBenefitsLevel(String benefitName) {
        Map<String, Integer> benefits = this.getTotalBenefits();
        return benefits.getOrDefault(benefitName, 0);
    }
}

