/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.Level;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.lang.DynamicLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class TownUpgrade {
    private final String name;
    private final String materialCode;
    private final int col;
    private final int row;
    private final int maxLevel;
    private final List<Integer> cost;
    private final Map<String, Integer> prerequisites;
    private final Map<String, Integer> benefits;

    public TownUpgrade(String name, int col, int row, String materialCode, int maxLevel, List<Integer> cost, Map<String, Integer> prerequisites, Map<String, Integer> benefits) {
        this.name = name;
        this.col = col;
        this.row = row;
        this.materialCode = materialCode;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.prerequisites = prerequisites;
        this.benefits = benefits;
    }

    public String getName() {
        return this.name;
    }

    public String getMaterialCode() {
        if (this.materialCode == null) {
            return "BEDROCK";
        }
        return this.materialCode;
    }

    public int getCost(int level) {
        if (this.cost.size() <= level) {
            return this.cost.getLast();
        }
        return this.cost.get(level);
    }

    public Map<String, Integer> getPrerequisites() {
        return this.prerequisites;
    }

    public Map<String, Integer> getBenefits() {
        return this.benefits;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public List<String> getItemLore(LangType lang, Level townLevelClass, int townUpgradeLevel) {
        Integer value;
        String prerequisiteName;
        ArrayList<String> lore = new ArrayList<String>();
        boolean isMaxLevel = townUpgradeLevel >= this.getMaxLevel();
        lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC1.get(lang, townUpgradeLevel + "/" + this.getMaxLevel()));
        if (isMaxLevel) {
            lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC2_MAX_LEVEL.get(lang, new String[0]));
        } else {
            lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC2.get(lang, Integer.toString(townUpgradeLevel + 1), Integer.toString(this.getCost(townUpgradeLevel))));
        }
        if (!this.prerequisites.isEmpty()) {
            lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC3.get(lang, new String[0]));
            for (Map.Entry<String, Integer> entry : this.getPrerequisites().entrySet()) {
                prerequisiteName = entry.getKey();
                Integer levelNeeded = entry.getValue();
                Integer currentLevel = townLevelClass.getUpgradeLevel(prerequisiteName);
                if (levelNeeded <= townLevelClass.getUpgradeLevel(prerequisiteName)) {
                    lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC3_1.get(lang, DynamicLang.get(lang, prerequisiteName), Integer.toString(currentLevel), Integer.toString(levelNeeded)));
                    continue;
                }
                lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC3_2.get(lang, DynamicLang.get(lang, prerequisiteName), Integer.toString(currentLevel), Integer.toString(levelNeeded)));
            }
        }
        if (!isMaxLevel) {
            lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4.get(lang, new String[0]));
            for (Map.Entry<String, Integer> entry : this.getBenefits().entrySet()) {
                prerequisiteName = entry.getKey();
                value = entry.getValue();
                if (value > 0) {
                    lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4_1.get(lang, DynamicLang.get(lang, prerequisiteName), Integer.toString(value)));
                    continue;
                }
                lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4_2.get(lang, DynamicLang.get(lang, prerequisiteName), Integer.toString(value)));
            }
        }
        lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC5.get(lang, new String[0]));
        for (Map.Entry<String, Integer> entry : this.getBenefits().entrySet()) {
            String benefitName = entry.getKey();
            value = entry.getValue();
            if (value > 0) {
                lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4_1.get(lang, DynamicLang.get(lang, benefitName), Integer.toString(value * townUpgradeLevel)));
                continue;
            }
            lore.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4_2.get(lang, DynamicLang.get(lang, benefitName), Integer.toString(value * townUpgradeLevel)));
        }
        return lore;
    }

    public boolean isPrerequisiteMet(Level townLevel) {
        if (this.prerequisites.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Integer> entry : this.getPrerequisites().entrySet()) {
            String prerequisiteName = entry.getKey();
            Integer levelNeeded = entry.getValue();
            Integer currentLevel = townLevel.getUpgradeLevel(prerequisiteName);
            if (levelNeeded <= currentLevel) continue;
            return false;
        }
        return true;
    }

    public GuiItem createGuiItem(Player player, TownData townData, int page) {
        Level townLevel = townData.getLevel();
        int townUpgradeLevel = townLevel.getUpgradeLevel(this.getName());
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        List<String> lore = this.getItemLore(tanPlayer.getLang(), townLevel, townUpgradeLevel);
        ItemStack upgradeItemStack = HeadUtils.createCustomItemStack(Material.getMaterial((String)this.getMaterialCode()), DynamicLang.get(tanPlayer.getLang(), this.getName()), lore);
        return ItemBuilder.from(upgradeItemStack).asGuiItem(event -> {
            event.setCancelled(true);
            if (!this.isPrerequisiteMet(townLevel)) {
                TanChatUtils.message(player, Lang.GUI_TOWN_LEVEL_UP_UNI_REQ_NOT_MET.get(tanPlayer.getLang(), new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            townData.upgradeTown(player, this, townUpgradeLevel);
            PlayerGUI.openTownLevel(player, page);
        });
    }
}

