/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.newhistory;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.utils.gameplay.TerritoryUtil;

public abstract class TransactionHistory
implements Comparable<TransactionHistory> {
    private final String date;
    private final String transactionParty;
    private final String territoryDataID;
    private final double amount;

    protected TransactionHistory(String date, String territoryDataID, String transactionParty, double amount) {
        this.date = date;
        this.territoryDataID = territoryDataID;
        this.transactionParty = transactionParty;
        this.amount = amount;
    }

    protected TransactionHistory(String territoryDataID, String transactionParty, double amount) {
        this.date = this.dateToString(LocalDate.now());
        this.territoryDataID = territoryDataID;
        this.transactionParty = transactionParty;
        this.amount = amount;
    }

    public String dateToString(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MM yyyy");
        return date.format(formatter);
    }

    public long dateToLong(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MM yyyy");
        LocalDate localDate = LocalDate.parse(date, formatter);
        return localDate.toEpochDay();
    }

    public abstract TransactionHistoryEnum getType();

    @Override
    public int compareTo(@NotNull TransactionHistory o) {
        return Long.compare(this.dateToLong(this.date), this.dateToLong(o.date));
    }

    public String getDate() {
        return this.date;
    }

    public String getTransactionParty() {
        return this.transactionParty;
    }

    public String getTerritoryDataID() {
        return this.territoryDataID;
    }

    public double getAmount() {
        return this.amount;
    }

    protected TerritoryData getTerritoryData() {
        return TerritoryUtil.getTerritory(this.getTerritoryDataID());
    }

    public abstract String addLoreLine();
}

