/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.economy;

import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.economy.TanEconomyStandalone;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.constants.Constants;

public class TanEconomyVault
extends TanEconomyStandalone
implements Economy {
    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "Towns and Nations Economy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return Constants.getNbDigits();
    }

    public String format(double v) {
        return String.valueOf(v);
    }

    public String currencyNamePlural() {
        return Constants.getBaseCurrencyChar();
    }

    public String currencyNameSingular() {
        return Constants.getBaseCurrencyChar();
    }

    public boolean hasAccount(String s) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return true;
    }

    public boolean hasAccount(String s, String s1) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s) {
        return true;
    }

    public double getBalance(String s) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)s));
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        return super.getBalance(PlayerDataStorage.getInstance().get(offlinePlayer));
    }

    public double getBalance(String s, String s1) {
        return this.getBalance(s);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String s, double v) {
        return this.getBalance(s) >= v;
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        return this.getBalance(offlinePlayer) > v;
    }

    public boolean has(String s, String s1, double v) {
        return this.getBalance(s) > v;
    }

    public boolean has(OfflinePlayer offlinePlayer, String s, double v) {
        return this.getBalance(offlinePlayer) > v;
    }

    public EconomyResponse withdrawPlayer(String s, double v) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double v) {
        if (v < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (!this.has(offlinePlayer, v)) {
            return new EconomyResponse(v, PlayerDataStorage.getInstance().get(offlinePlayer).getBalance(), EconomyResponse.ResponseType.FAILURE, "Player does not have enough money");
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(offlinePlayer);
        tanPlayer.removeFromBalance((int)v);
        return new EconomyResponse(v, tanPlayer.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse withdrawPlayer(String s, String s1, double v) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.withdrawPlayer(offlinePlayer, v);
    }

    public EconomyResponse depositPlayer(String s, double v) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double v) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(offlinePlayer);
        tanPlayer.addToBalance((int)v);
        return new EconomyResponse(v, tanPlayer.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public EconomyResponse depositPlayer(String s, String s1, double v) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.depositPlayer(offlinePlayer, v);
    }

    public EconomyResponse createBank(String s, String s1) {
        return null;
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse deleteBank(String s) {
        return null;
    }

    public EconomyResponse bankBalance(String s) {
        return null;
    }

    public EconomyResponse bankHas(String s, double v) {
        return null;
    }

    public EconomyResponse bankWithdraw(String s, double v) {
        return null;
    }

    public EconomyResponse bankDeposit(String s, double v) {
        return null;
    }

    public EconomyResponse isBankOwner(String s, String s1) {
        return null;
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse isBankMember(String s, String s1) {
        return null;
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        return null;
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean createPlayerAccount(String s) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        return false;
    }

    public boolean createPlayerAccount(String s, String s1) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        return false;
    }
}

