/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.enums;

import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;

public enum ClaimType {
    TOWN(Lang.MAP_TOWN, "TOWN"),
    REGION(Lang.MAP_REGION, "REGION");

    private final Lang buttonName;
    private final String buttonCommand;
    private ClaimType nextType;

    private ClaimType(Lang buttonName, String buttonCommand) {
        this.buttonName = buttonName;
        this.buttonCommand = buttonCommand;
    }

    public String getName(LangType langType) {
        return this.buttonName.get(langType, new String[0]);
    }

    public String getTypeCommand() {
        return this.buttonCommand;
    }

    public ClaimType getNextType() {
        return this.nextType;
    }

    private void setNextType(ClaimType nextType) {
        this.nextType = nextType;
    }

    static {
        TOWN.setNextType(REGION);
        REGION.setNextType(TOWN);
    }
}

