/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.leralix.tan.TownsAndNations;
import org.tan.api.events.TanEvent;
import org.tan.api.events.TanListener;
import org.tan.api.getters.TanEventManager;

public class EventManager
implements TanEventManager {
    private final Map<Class<?>, List<RegisteredListener>> listeners = new HashMap();
    static EventManager instance;

    private EventManager() {
    }

    public static EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    @Override
    public void registerEvents(TanListener listenerInstance) {
        for (Method method : listenerInstance.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            if (!method.isAnnotationPresent(TanListener.EventHandler.class) || (params = method.getParameterTypes()).length != 1) continue;
            Class<?> eventType = params[0];
            method.setAccessible(true);
            RegisteredListener registered = new RegisteredListener(listenerInstance, method);
            this.listeners.computeIfAbsent(eventType, e -> new ArrayList()).add(registered);
        }
    }

    public <T> void callEvent(T event) {
        for (Class<?> iface : event.getClass().getInterfaces()) {
            List<RegisteredListener> list;
            if (!TanEvent.class.isAssignableFrom(iface) || (list = this.listeners.get(iface)) == null) continue;
            for (RegisteredListener reg : list) {
                reg.invoke(event);
            }
        }
    }

    private record RegisteredListener(Object instance, Method method) {
        public void invoke(Object event) {
            try {
                this.method.invoke(this.instance, event);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                TownsAndNations.getPlugin().getLogger().warning("Failed to invoke event handler: " + e.getMessage());
            }
        }
    }
}

