/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.AttackCancelledByDefenderNewsletter;

public class AttackCancelledDAO
extends NewsletterSubDAO<AttackCancelledByDefenderNewsletter> {
    private static final String TABLE_NAME = "attack_cancelled_newsletter";

    public AttackCancelledDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS attack_cancelled_newsletter (id VARCHAR(36) PRIMARY KEY, attackingTerritoryID VARCHAR(36) NOT NULL, defendingTerritoryID VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create player diplomacy accepted newsletter table", e);
        }
    }

    @Override
    public void save(AttackCancelledByDefenderNewsletter newsletter) {
        String sql = "INSERT INTO attack_cancelled_newsletter (id, attackingTerritoryID, defendingTerritoryID) VALUES (?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getAttackingTerritoryID());
            ps.setString(3, newsletter.getDefendingTerritoryID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save player application newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AttackCancelledByDefenderNewsletter load(UUID id, long date) {
        String sql = "SELECT attackingTerritoryID, defendingTerritoryID FROM attack_cancelled_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String attackingTerritoryID = rs.getString("attackingTerritoryID");
                String defendingTerritoryID = rs.getString("defendingTerritoryID");
                AttackCancelledByDefenderNewsletter attackCancelledByDefenderNewsletter = new AttackCancelledByDefenderNewsletter(id, date, attackingTerritoryID, defendingTerritoryID);
                return attackCancelledByDefenderNewsletter;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load player application newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM attack_cancelled_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table attack_cancelled_newsletter", e);
        }
    }
}

