/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.events.newsletter.dao.AttackCancelledDAO;
import org.leralix.tan.events.newsletter.dao.AttackDeclaredDAO;
import org.leralix.tan.events.newsletter.dao.AttackWonByAttackerDAO;
import org.leralix.tan.events.newsletter.dao.AttackWonByDefenderDAO;
import org.leralix.tan.events.newsletter.dao.DiplomacyAcceptedDAO;
import org.leralix.tan.events.newsletter.dao.DiplomacyProposalDAO;
import org.leralix.tan.events.newsletter.dao.LandmarkClaimedDAO;
import org.leralix.tan.events.newsletter.dao.LandmarkUnclaimedDAO;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.dao.PlayerApplicationDAO;
import org.leralix.tan.events.newsletter.dao.PlayerCreateRegionDAO;
import org.leralix.tan.events.newsletter.dao.PlayerCreateTownDAO;
import org.leralix.tan.events.newsletter.dao.PlayerDeleteRegionDAO;
import org.leralix.tan.events.newsletter.dao.PlayerDeleteTownDAO;
import org.leralix.tan.events.newsletter.dao.PlayerJoinTownDAO;
import org.leralix.tan.events.newsletter.dao.TerritoryVassalAcceptedDAO;
import org.leralix.tan.events.newsletter.dao.TerritoryVassalForcedDAO;
import org.leralix.tan.events.newsletter.dao.TerritoryVassalIndependentDAO;
import org.leralix.tan.events.newsletter.dao.TerritoryVassalProposalDAO;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.timezone.TimeZoneManager;

public class NewsletterDAO {
    private final Map<NewsletterType, NewsletterSubDAO<?>> subDaos = new EnumMap(NewsletterType.class);
    private final DataSource dataSource;

    public NewsletterDAO(DataSource dataSource) {
        this.dataSource = dataSource;
        this.createTableIfNotExists();
        this.subDaos.put(NewsletterType.TOWN_CREATED, new PlayerCreateTownDAO(dataSource));
        this.subDaos.put(NewsletterType.TOWN_DELETED, new PlayerDeleteTownDAO(dataSource));
        this.subDaos.put(NewsletterType.PLAYER_APPLICATION, new PlayerApplicationDAO(dataSource));
        this.subDaos.put(NewsletterType.PLAYER_JOIN_TOWN, new PlayerJoinTownDAO(dataSource));
        this.subDaos.put(NewsletterType.REGION_CREATED, new PlayerCreateRegionDAO(dataSource));
        this.subDaos.put(NewsletterType.REGION_DELETED, new PlayerDeleteRegionDAO(dataSource));
        this.subDaos.put(NewsletterType.TERRITORY_VASSAL_PROPOSAL, new TerritoryVassalProposalDAO(dataSource));
        this.subDaos.put(NewsletterType.TERRITORY_VASSAL_ACCEPTED, new TerritoryVassalAcceptedDAO(dataSource));
        this.subDaos.put(NewsletterType.TERRITORY_VASSAL_FORCED, new TerritoryVassalForcedDAO(dataSource));
        this.subDaos.put(NewsletterType.TERRITORY_VASSAL_INDEPENDENT, new TerritoryVassalIndependentDAO(dataSource));
        this.subDaos.put(NewsletterType.DIPLOMACY_ACCEPTED, new DiplomacyAcceptedDAO(dataSource));
        this.subDaos.put(NewsletterType.DIPLOMACY_PROPOSAL, new DiplomacyProposalDAO(dataSource));
        this.subDaos.put(NewsletterType.LANDMARK_CLAIMED, new LandmarkClaimedDAO(dataSource));
        this.subDaos.put(NewsletterType.LANDMARK_UNCLAIMED, new LandmarkUnclaimedDAO(dataSource));
        this.subDaos.put(NewsletterType.ATTACK_DECLARED, new AttackDeclaredDAO(dataSource));
        this.subDaos.put(NewsletterType.ATTACK_WON_BY_ATTACKER, new AttackWonByAttackerDAO(dataSource));
        this.subDaos.put(NewsletterType.ATTACK_WON_BY_DEFENDER, new AttackWonByDefenderDAO(dataSource));
        this.subDaos.put(NewsletterType.ATTACK_CANCELLED, new AttackCancelledDAO(dataSource));
    }

    private void createTableIfNotExists() {
        String sql1 = "CREATE TABLE IF NOT EXISTS newsletter (id VARCHAR(36) PRIMARY KEY, type VARCHAR(255) NOT NULL, date_created TIMESTAMP NOT NULL)";
        String sql2 = "CREATE TABLE IF NOT EXISTS newsletter_read (newsletter_id VARCHAR(36) NOT NULL, player_id VARCHAR(36) NOT NULL, PRIMARY KEY (newsletter_id, player_id))";
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql1);
            stmt.executeUpdate(sql2);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create newsletter tables", e);
        }
    }

    public void save(Newsletter newsletter) throws SQLException {
        String sql = "INSERT INTO newsletter (id, type, date_created) VALUES (?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getType().name());
            ps.setTimestamp(3, Timestamp.from(Instant.ofEpochMilli(newsletter.getDate())));
            ps.executeUpdate();
        }
        NewsletterSubDAO<?> subDAO = this.subDaos.get((Object)newsletter.getType());
        if (subDAO == null) {
            throw new IllegalStateException("No DAO for type " + String.valueOf((Object)newsletter.getType()));
        }
        subDAO.save(newsletter);
    }

    public void markAsRead(UUID newsletterId, UUID playerId) {
        String sql = "INSERT INTO newsletter_read (newsletter_id, player_id) VALUES (?, ?) ON CONFLICT DO NOTHING";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletterId);
            ps.setObject(2, playerId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to add entry in newsletter_read table", e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasRead(UUID newsletterId, UUID playerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Newsletter> getNewsletters() {
        String sql = "SELECT * FROM newsletter WHERE date_created <= ? ORDER BY date_created DESC";
        ArrayList<Newsletter> newsletters = new ArrayList<Newsletter>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setTimestamp(1, Timestamp.from(Instant.now()));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    UUID id = UUID.fromString(rs.getString("id"));
                    Timestamp timestamp = rs.getTimestamp("date_created");
                    if (timestamp == null) {
                        TownsAndNations.getPlugin().getLogger().warning("Newsletter " + String.valueOf(id) + " has null date_created, skipping.");
                        continue;
                    }
                    LocalDateTime createdAt = timestamp.toLocalDateTime();
                    String typeName = rs.getString("type");
                    if (!NewsletterType.isValidEnumValue(typeName)) {
                        TownsAndNations.getPlugin().getLogger().severe("Invalid newsletter type: " + typeName);
                        this.removeNewsletter(id);
                        continue;
                    }
                    NewsletterType type = NewsletterType.valueOf(typeName);
                    NewsletterSubDAO<?> subDAO = this.subDaos.get((Object)type);
                    if (subDAO == null) {
                        TownsAndNations.getPlugin().getLogger().severe("No DAO for newsletter type " + String.valueOf((Object)type) + ", id: " + String.valueOf(id));
                        continue;
                    }
                    ZoneOffset zoneOffset = TimeZoneManager.getInstance().getTimezoneEnum().toZoneOffset();
                    long createdAtMillis = createdAt.toInstant(zoneOffset).toEpochMilli();
                    Object newsletter = subDAO.load(id, createdAtMillis);
                    if (newsletter == null) continue;
                    newsletters.add((Newsletter)newsletter);
                }
            }
        }
        catch (SQLException e) {
            TownsAndNations.getPlugin().getLogger().severe("Failed to retrieve newsletters: " + e.getMessage());
            return Collections.emptyList();
        }
        return newsletters;
    }

    private void removeNewsletter(UUID id) {
        String sql = "DELETE FROM newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to remove newsletter", e);
        }
    }

    public void deleteOldNewsletters(int nbDays) {
        Duration duration = Duration.ofDays(nbDays);
        LocalDateTime cutoff = LocalDateTime.now().minus(duration);
        String selectSql = "SELECT id, type FROM newsletter WHERE date_created < ?";
        ArrayList<UUID> idsToDelete = new ArrayList<UUID>();
        ArrayList<NewsletterType> typesToDelete = new ArrayList<NewsletterType>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(selectSql);){
            ps.setTimestamp(1, Timestamp.valueOf(cutoff));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String idStr = rs.getString("id");
                    String typeStr = rs.getString("type");
                    if (!NewsletterType.isValidEnumValue(typeStr)) continue;
                    idsToDelete.add(UUID.fromString(idStr));
                    typesToDelete.add(NewsletterType.valueOf(typeStr));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to select old newsletters", e);
        }
        for (int i = 0; i < idsToDelete.size(); ++i) {
            UUID id = (UUID)idsToDelete.get(i);
            NewsletterType type = (NewsletterType)((Object)typesToDelete.get(i));
            NewsletterSubDAO<?> subDAO = this.subDaos.get((Object)type);
            if (subDAO != null) {
                subDAO.delete(id);
            }
            this.removeNewsletter(id);
        }
    }
}

