/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.RegionCreationNews;

public class PlayerCreateRegionDAO
extends NewsletterSubDAO<RegionCreationNews> {
    private static final String TABLE_NAME = "player_create_region_newsletter";

    public PlayerCreateRegionDAO(DataSource connection) {
        super(connection);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS player_create_region_newsletter (id VARCHAR(36) PRIMARY KEY, playerID VARCHAR(36) NOT NULL, regionID VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create player_create_region_newsletter table", e);
        }
    }

    @Override
    public void save(RegionCreationNews newsletter) {
        String sql = "INSERT INTO player_create_region_newsletter (id, playerID, regionID) VALUES (?, ?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getPlayerID());
            ps.setString(3, newsletter.getRegionID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save newsletter to player_create_region_newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RegionCreationNews load(UUID id, long date) {
        String sql = "SELECT playerID, regionID FROM player_create_region_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String playerID = rs.getString("playerID");
                String regionID = rs.getString("regionID");
                RegionCreationNews regionCreationNews = new RegionCreationNews(id, date, playerID, regionID);
                return regionCreationNews;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load newsletter from player_create_region_newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM player_create_region_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete newsletter from player_create_region_newsletter", e);
        }
    }
}

