/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.news;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.tan.api.enums.EDiplomacyState;
import org.tan.api.interfaces.TanTerritory;

public class DiplomacyAcceptedNews
extends Newsletter {
    private final String proposingTerritoryID;
    private final String receivingTerritoryID;
    private final TownRelation wantedRelation;
    private final boolean isRelationWorse;

    public DiplomacyAcceptedNews(UUID id, long date, String proposingTerritoryID, String receivingTerritoryID, TownRelation wantedRelation, boolean isRelationWorse) {
        super(id, date);
        this.proposingTerritoryID = proposingTerritoryID;
        this.receivingTerritoryID = receivingTerritoryID;
        this.wantedRelation = wantedRelation;
        this.isRelationWorse = isRelationWorse;
    }

    public DiplomacyAcceptedNews(TanTerritory proposingTerritory, TanTerritory receivingTerritory, EDiplomacyState newRelation, boolean isRelationBetter) {
        this.proposingTerritoryID = proposingTerritory.getID();
        this.receivingTerritoryID = receivingTerritory.getID();
        this.wantedRelation = TownRelation.fromAPI(newRelation);
        this.isRelationWorse = !isRelationBetter;
    }

    @Override
    public NewsletterType getType() {
        return NewsletterType.DIPLOMACY_ACCEPTED;
    }

    public String getProposingTerritoryID() {
        return this.proposingTerritoryID;
    }

    public String getReceivingTerritoryID() {
        return this.receivingTerritoryID;
    }

    public TownRelation getWantedRelation() {
        return this.wantedRelation;
    }

    public boolean isRelationWorse() {
        return this.isRelationWorse;
    }

    @Override
    public void broadcast(Player player) {
        TerritoryData proposingTerritory = TerritoryUtil.getTerritory(this.proposingTerritoryID);
        if (proposingTerritory == null) {
            return;
        }
        TerritoryData receivingTerritory = TerritoryUtil.getTerritory(this.receivingTerritoryID);
        if (receivingTerritory == null) {
            return;
        }
        LangType lang = PlayerDataStorage.getInstance().get(player).getLang();
        if (this.isRelationWorse) {
            TanChatUtils.message(player, Lang.BROADCAST_RELATION_WORSEN.get(player, proposingTerritory.getCustomColoredName().toLegacyText(), receivingTerritory.getCustomColoredName().toLegacyText(), this.wantedRelation.getColoredName(lang)), SoundEnum.BAD);
        } else {
            TanChatUtils.message(player, Lang.BROADCAST_RELATION_IMPROVE.get(player, proposingTerritory.getCustomColoredName().toLegacyText(), receivingTerritory.getCustomColoredName().toLegacyText(), this.wantedRelation.getColoredName(lang)), SoundEnum.GOOD);
        }
    }

    @Override
    public GuiItem createGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        TerritoryData proposingTerritory = TerritoryUtil.getTerritory(this.proposingTerritoryID);
        if (proposingTerritory == null) {
            return null;
        }
        TerritoryData receivingTerritory = TerritoryUtil.getTerritory(this.receivingTerritoryID);
        if (receivingTerritory == null) {
            return null;
        }
        ItemStack itemStack = HeadUtils.makeSkullURL(Lang.DIPLOMACY_ACCEPT_NEWSLETTER_TITLE.get(lang, new String[0]), "http://textures.minecraft.net/texture/b62c08805bd9c957da3450554a09e994042f54695db855c1c2cb47ef442e1bf6", Lang.NEWSLETTER_DATE.get(lang, TimeZoneManager.getInstance().getRelativeTimeDescription(lang, this.getDate())), Lang.BROADCAST_RELATION_WORSEN.get(lang, proposingTerritory.getCustomColoredName().toLegacyText(), receivingTerritory.getCustomColoredName().toLegacyText(), this.wantedRelation.getColoredName(lang)), Lang.NEWSLETTER_RIGHT_CLICK_TO_MARK_AS_READ.get(lang, new String[0]));
        return ItemBuilder.from(itemStack).asGuiItem(e -> {
            e.setCancelled(true);
            if (e.isRightClick()) {
                this.markAsRead(player);
                onClick.accept(player);
            }
        });
    }

    @Override
    public GuiItem createConcernedGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        return this.createGuiItem(player, lang, onClick);
    }

    @Override
    public boolean shouldShowToPlayer(Player player) {
        TerritoryData proposingTerritory = TerritoryUtil.getTerritory(this.proposingTerritoryID);
        if (proposingTerritory == null) {
            return false;
        }
        TerritoryData receivingTerritory = TerritoryUtil.getTerritory(this.receivingTerritoryID);
        if (receivingTerritory == null) {
            return false;
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        return receivingTerritory.isPlayerIn(tanPlayer) || proposingTerritory.isPlayerIn(tanPlayer);
    }

    @Override
    public void broadcastConcerned(Player player) {
        this.broadcast(player);
    }
}

