/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.news;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.lang.LangType;

public abstract class Newsletter {
    private final UUID id;
    private final long date;

    protected Newsletter(UUID id, long date) {
        this.id = id;
        this.date = date;
    }

    protected Newsletter() {
        this.id = UUID.randomUUID();
        this.date = System.currentTimeMillis();
    }

    public UUID getId() {
        return this.id;
    }

    public abstract GuiItem createGuiItem(Player var1, LangType var2, Consumer<Player> var3);

    public abstract GuiItem createConcernedGuiItem(Player var1, LangType var2, Consumer<Player> var3);

    public abstract boolean shouldShowToPlayer(Player var1);

    public long getDate() {
        return this.date;
    }

    public abstract NewsletterType getType();

    public void markAsRead(Player player) {
        this.markAsRead(player.getUniqueId());
    }

    public void markAsRead(ITanPlayer tanPlayer) {
        this.markAsRead(UUID.fromString(tanPlayer.getID()));
    }

    public void markAsRead(UUID playerID) {
        NewsletterStorage.getInstance().getNewsletterDAO().markAsRead(this.id, playerID);
    }

    public boolean isRead(Player player) {
        return this.isRead(player.getUniqueId());
    }

    public boolean isRead(UUID playerID) {
        return NewsletterStorage.getInstance().getNewsletterDAO().hasRead(this.id, playerID);
    }

    public abstract void broadcast(Player var1);

    public abstract void broadcastConcerned(Player var1);
}

