/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.player.PlayerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class MainMenu
extends BasicGui {
    public MainMenu(Player player) {
        super(player, Lang.HEADER_MAIN_MENU, 3);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getTimeIcon());
        int nationPosition = 2;
        int regionPosition = 4;
        int townPosition = 6;
        int playerPosition = 8;
        if (Constants.enableRegion()) {
            if (Constants.enableNation()) {
                this.gui.setItem(2, nationPosition, this.getNationButton(this.tanPlayer));
            } else {
                regionPosition = 3;
                townPosition = 5;
                playerPosition = 7;
            }
            this.gui.setItem(2, regionPosition, this.getRegionButton(this.tanPlayer));
        } else {
            townPosition = 4;
            playerPosition = 6;
        }
        this.gui.setItem(2, townPosition, this.getTownButton(this.tanPlayer));
        this.gui.setItem(2, playerPosition, this.getPlayerButton(this.tanPlayer));
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, HumanEntity::closeInventory));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getTimeIcon() {
        TimeZoneManager timeManager = TimeZoneManager.getInstance();
        IconKey icon = timeManager.isDayForServer() ? IconKey.TIMEZONE_ICON_DAY : IconKey.TIMEZONE_ICON_NIGHT;
        return this.iconManager.get(icon).setName(Lang.GUI_SERVER_TIME.get(this.tanPlayer)).setDescription(Lang.CURRENT_SERVER_TIME.get(this.tanPlayer, timeManager.formatDateNowForServer()), Lang.CURRENT_PLAYER_TIME.get(this.tanPlayer, timeManager.formatDateNowForPlayer(this.tanPlayer))).asGuiItem(this.player);
    }

    private GuiItem getNationButton(ITanPlayer tanPlayer) {
        return this.iconManager.get(IconKey.NATION_BASE_ICON).setName(Lang.GUI_KINGDOM_ICON.get(tanPlayer)).setDescription(Lang.GUI_WARNING_STILL_IN_DEV.get(tanPlayer)).setAction(action -> TanChatUtils.message(this.player, Lang.GUI_WARNING_STILL_IN_DEV.get(tanPlayer), SoundEnum.NOT_ALLOWED)).asGuiItem(this.player);
    }

    private GuiItem getRegionButton(ITanPlayer tanPlayer) {
        ArrayList<String> description = new ArrayList<String>();
        if (tanPlayer.hasRegion()) {
            RegionData regionData = tanPlayer.getRegion();
            description.add(Lang.GUI_REGION_ICON_DESC1_REGION.get(tanPlayer, regionData.getColoredName()));
            description.add(Lang.GUI_REGION_ICON_DESC2_REGION.get(tanPlayer, regionData.getRank(tanPlayer).getColoredName()));
        } else {
            description.add(Lang.GUI_REGION_ICON_DESC1_NO_REGION.get(tanPlayer));
        }
        description.add(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(tanPlayer));
        return this.iconManager.get(IconKey.REGION_BASE_ICON).setName(Lang.GUI_REGION_ICON.get(tanPlayer)).setDescription(description).setAction(action -> PlayerGUI.dispatchPlayerRegion(this.player)).asGuiItem(this.player);
    }

    private GuiItem getTownButton(ITanPlayer tanPlayer) {
        ArrayList<String> description = new ArrayList<String>();
        if (tanPlayer.hasTown()) {
            description.add(Lang.GUI_TOWN_ICON_DESC1_HAVE_TOWN.get(tanPlayer, tanPlayer.getTown().getColoredName()));
            description.add(Lang.GUI_TOWN_ICON_DESC2_HAVE_TOWN.get(tanPlayer, tanPlayer.getTown().getRank(tanPlayer).getColoredName()));
        } else {
            description.add(Lang.GUI_TOWN_ICON_DESC1_NO_TOWN.get(tanPlayer));
        }
        description.add(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(tanPlayer));
        return this.iconManager.get(IconKey.TOWN_BASE_ICON).setName(Lang.GUI_TOWN_ICON.get(tanPlayer)).setDescription(description).setAction(action -> PlayerGUI.dispatchPlayerTown(this.player)).asGuiItem(this.player);
    }

    private GuiItem getPlayerButton(ITanPlayer tanPlayer) {
        return this.iconManager.get(IconKey.PLAYER_BASE_ICON).setName(Lang.GUI_PLAYER_MENU_ICON.get(tanPlayer, this.player.getName())).setDescription(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(tanPlayer)).setAction(action -> new PlayerMenu(this.player)).asGuiItem(this.player);
    }
}

