/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.player.PlayerMenu;
import org.leralix.tan.gui.user.property.PlayerPropertyManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.listeners.interact.events.property.CreatePlayerPropertyEvent;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class PlayerPropertiesMenu
extends IteratorGUI {
    public PlayerPropertiesMenu(Player player) {
        super(player, Lang.HEADER_PLAYER_PROPERTIES, 3);
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getProperties(), this.page, this.player, p -> new PlayerMenu(this.player).open(), p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(3, 5, this.getNewPropertyButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getNewPropertyButton() {
        ArrayList<String> description = new ArrayList<String>();
        if (this.tanPlayer.hasTown()) {
            TownData townData = this.tanPlayer.getTown();
            int nbProperties = townData.getProperties().size();
            int maxNbProperties = townData.getLevel().getPropertyCap();
            double costPerBlock = townData.getTaxOnCreatingProperty();
            if (nbProperties >= maxNbProperties) {
                description.add(Lang.GUI_PROPERTY_CAP_FULL.get(this.langType, Integer.toString(nbProperties), Integer.toString(maxNbProperties)));
            } else {
                description.add(Lang.GUI_PROPERTY_CAP.get(this.langType, Integer.toString(nbProperties), Integer.toString(maxNbProperties)));
            }
            if (costPerBlock > 0.0) {
                description.add(Lang.GUI_PROPERTY_COST_PER_BLOCK.get(this.langType, Double.toString(costPerBlock)));
            }
        } else {
            description.add(Lang.PLAYER_NO_TOWN.get(this.langType, new String[0]));
        }
        return this.iconManager.get(IconKey.CREATE_NEW_PROPERTY_ICON).setName(Lang.GUI_PLAYER_NEW_PROPERTY.get(this.tanPlayer)).setDescription(description).setAction(event -> {
            TownData playerTown = this.tanPlayer.getTown();
            if (!playerTown.doesPlayerHavePermission(this.tanPlayer, RolePermission.CREATE_PROPERTY)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            if (playerTown.getPropertyDataMap().size() >= playerTown.getLevel().getPropertyCap()) {
                TanChatUtils.message(this.player, Lang.PLAYER_PROPERTY_CAP_REACHED.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            TanChatUtils.message(this.player, Lang.PLAYER_RIGHT_CLICK_2_POINTS_TO_CREATE_PROPERTY.get(this.tanPlayer));
            TanChatUtils.message(this.player, Lang.WRITE_CANCEL_TO_CANCEL.get(this.tanPlayer, Lang.CANCEL_WORD.get(this.tanPlayer)));
            RightClickListener.register(this.player, new CreatePlayerPropertyEvent(this.player));
            this.player.closeInventory();
        }).asGuiItem(this.player);
    }

    private List<GuiItem> getProperties() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (PropertyData propertyData : this.tanPlayer.getProperties()) {
            List<String> desc = propertyData.getBasicDescription(this.tanPlayer.getLang());
            desc.add(Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer));
            guiItems.add(this.iconManager.get(propertyData.getIcon()).setName(propertyData.getName()).setDescription(desc).setAction(event -> new PlayerPropertyManager(this.player, propertyData, p -> this.open())).asGuiItem(this.player));
        }
        return guiItems;
    }
}

