/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.ranks;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.ranks.RankManagerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.TanChatUtils;

public class ManageRankPermissionMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final RankData rankData;

    public ManageRankPermissionMenu(Player player, TerritoryData territoryData, RankData rankData) {
        super(player, Lang.HEADER_RANK_PERMISSIONS, 4);
        this.territoryData = territoryData;
        this.rankData = rankData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getItems(), p -> new RankManagerMenu(this.player, this.territoryData, this.rankData));
        this.gui.open((HumanEntity)this.player);
    }

    public List<GuiItem> getItems() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (RolePermission permission : RolePermission.values()) {
            if (!permission.isForTerritory(this.territoryData)) continue;
            guiItems.add(this.iconManager.get(permission.getIconKey()).setName(permission.getName().get(this.tanPlayer)).setDescription(this.rankData.hasPermission(permission) ? Lang.GUI_TOWN_MEMBERS_ROLE_HAS_PERMISSION.get(this.tanPlayer) : Lang.GUI_TOWN_MEMBERS_ROLE_NO_PERMISSION.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_MODIFY.get(this.tanPlayer)).setAction(event -> {
                event.setCancelled(true);
                if (!this.territoryData.getRank(this.player).hasPermission(permission) && !this.territoryData.isLeader(this.player)) {
                    TanChatUtils.message(this.player, Lang.ERROR_CANNOT_CHANGE_PERMISSION_IF_PLAYER_RANK_DOES_NOT_HAVE_IT.get(this.player), SoundEnum.NOT_ALLOWED);
                    return;
                }
                this.rankData.switchPermission(permission);
                this.open();
            }).asGuiItem(this.player));
        }
        return guiItems;
    }
}

