/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.building.Building;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.listeners.interact.events.CreateFortEvent;
import org.leralix.tan.listeners.interact.events.property.CreateTerritoryPropertyEvent;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.text.TanChatUtils;

public class BuildingMenu
extends IteratorGUI {
    private final BasicGui previousMenu;
    private final TerritoryData territoryData;

    public BuildingMenu(Player player, TerritoryData territoryData, BasicGui previousMenu) {
        super(player, Lang.HEADER_BUILDING_MENU, 4);
        this.territoryData = territoryData;
        this.previousMenu = previousMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getBuildings(), p -> this.previousMenu.open());
        TerritoryData territoryData = this.territoryData;
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            this.gui.setItem(4, 4, this.getCreatePublicPropertyButton(townData));
        }
        this.gui.setItem(4, 5, this.getCreateFortButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getCreatePublicPropertyButton(TownData townData) {
        int maxNbProperties;
        ArrayList<String> description = new ArrayList<String>();
        int nbProperties = townData.getProperties().size();
        if (nbProperties >= (maxNbProperties = townData.getLevel().getPropertyCap())) {
            description.add(Lang.GUI_PROPERTY_CAP_FULL.get(this.langType, Integer.toString(nbProperties), Integer.toString(maxNbProperties)));
        } else {
            description.add(Lang.GUI_PROPERTY_CAP.get(this.langType, Integer.toString(nbProperties), Integer.toString(maxNbProperties)));
        }
        description.add(Lang.CREATE_PUBLIC_PROPERTY_COST.get(this.langType, new String[0]));
        description.add(Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.langType, new String[0]));
        return this.iconManager.get(IconKey.PLAYER_PROPERTY_ICON).setName(Lang.CREATE_PUBLIC_PROPERTY_ICON.get(this.langType, new String[0])).setDescription(description).setAction(action -> {
            if (!townData.doesPlayerHavePermission(this.player, RolePermission.MANAGE_PROPERTY)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.langType, new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            if (nbProperties >= maxNbProperties) {
                TanChatUtils.message(this.player, Lang.GUI_PROPERTY_CAP_FULL.get(this.langType, Integer.toString(nbProperties), Integer.toString(maxNbProperties)), SoundEnum.NOT_ALLOWED);
                return;
            }
            RightClickListener.register(this.player, new CreateTerritoryPropertyEvent(this.player, townData));
        }).asGuiItem(this.player);
    }

    @NotNull
    private GuiItem getCreateFortButton() {
        return this.iconManager.get(IconKey.FORT_BUILDING_ICON).setName(Lang.CREATE_FORT_ICON.get(this.langType, new String[0])).setDescription(Lang.CREATE_FORT_DESC1.get(this.langType, Double.toString(Constants.getFortCost())), Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.langType, new String[0])).setAction(action -> {
            if (Constants.getFortCost() > this.territoryData.getBalance()) {
                TanChatUtils.message(this.player, Lang.TERRITORY_NOT_ENOUGH_MONEY.get(this.langType, this.territoryData.getColoredName(), Double.toString(Constants.getFortCost() - this.territoryData.getBalance())));
                return;
            }
            TanChatUtils.message(this.player, Lang.RIGHT_CLICK_TO_PLACE_FORT.get(this.langType, new String[0]));
            RightClickListener.register(this.player, new CreateFortEvent(this.territoryData));
            this.player.closeInventory();
        }).asGuiItem(this.player);
    }

    private List<GuiItem> getBuildings() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (Building building : this.territoryData.getBuildings()) {
            res.add(building.getGuiItem(this.iconManager, this.player, this.territoryData, this));
        }
        return res;
    }
}

