/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.newhistory.TransactionHistory;
import org.leralix.tan.dataclass.newhistory.TransactionHistoryEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.TreasuryMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class EconomicHistoryMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final TransactionHistoryEnum transactionHistoryEnum;

    public EconomicHistoryMenu(Player player, TerritoryData territoryData, TransactionHistoryEnum transactionHistoryEnum) {
        super(player, Lang.HEADER_HISTORY.get(player), 6);
        this.territoryData = territoryData;
        this.transactionHistoryEnum = transactionHistoryEnum;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getEconomicsHistory(), p -> new TreasuryMenu(this.player, this.territoryData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getEconomicsHistory() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (List<TransactionHistory> transactionHistory : TownsAndNations.getPlugin().getDatabaseHandler().getTransactionHistory(this.territoryData, this.transactionHistoryEnum)) {
            ItemStack transactionIcon = HeadUtils.createCustomItemStack(Material.PAPER, String.valueOf(ChatColor.GREEN) + transactionHistory.get(0).getDate(), new String[0]);
            for (TransactionHistory transaction : transactionHistory) {
                HeadUtils.addLore(transactionIcon, transaction.addLoreLine());
            }
            guiItems.add(ItemBuilder.from(transactionIcon).asGuiItem(event -> event.setCancelled(true)));
        }
        Collections.reverse(guiItems);
        return guiItems;
    }
}

