/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.gui.user.player.ApplyToTownMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.CreateTown;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class NoTownMenu
extends BasicGui {
    public NoTownMenu(Player player) {
        super(player, Lang.HEADER_NO_TOWN_MENU, 3);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 3, this.getCreateTownButton());
        this.gui.setItem(2, 7, this.getBrowseTownsButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new MainMenu(this.player).open()));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getCreateTownButton() {
        int townPrice = Constants.getTownCost();
        return IconManager.getInstance().get(IconKey.CREATE_TOWN_ICON).setName(Lang.GUI_NO_TOWN_CREATE_NEW_TOWN.get(this.tanPlayer)).setDescription(Lang.GUI_NO_TOWN_CREATE_NEW_TOWN_DESC1.get(this.tanPlayer, Integer.toString(townPrice)), Lang.GUI_GENERIC_CLICK_TO_PROCEED.get(this.tanPlayer)).setAction(action -> {
            if (!this.player.hasPermission("tan.base.town.create")) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            double playerMoney = EconomyUtil.getBalance(this.player);
            if (playerMoney < (double)townPrice) {
                TanChatUtils.message(this.player, Lang.PLAYER_NOT_ENOUGH_MONEY_EXTENDED.get(this.tanPlayer, Double.toString((double)townPrice - playerMoney)), SoundEnum.NOT_ALLOWED);
            } else {
                TanChatUtils.message(this.player, Lang.PLAYER_WRITE_TOWN_NAME_IN_CHAT.get(this.tanPlayer));
                PlayerChatListenerStorage.register(this.player, new CreateTown(townPrice));
            }
        }).asGuiItem(this.player);
    }

    private GuiItem getBrowseTownsButton() {
        return IconManager.getInstance().get(IconKey.BROWSE_TOWN_ICON).setName(Lang.GUI_NO_TOWN_JOIN_A_TOWN.get(this.tanPlayer)).setDescription(Lang.GUI_NO_TOWN_JOIN_A_TOWN_DESC1.get(this.tanPlayer, Integer.toString(TownDataStorage.getInstance().getNumberOfTown())), Lang.GUI_GENERIC_CLICK_TO_OPEN.get(this.tanPlayer)).setAction(event -> new ApplyToTownMenu(this.player)).asGuiItem(this.player);
    }
}

