/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.RegionDeletednternalEvent;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.gui.user.territory.RegionMenu;
import org.leralix.tan.gui.user.territory.SettingsMenus;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.file.FileUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class RegionSettingsMenu
extends SettingsMenus {
    private final RegionData regionData;

    public RegionSettingsMenu(Player player, RegionData regionData) {
        super(player, Lang.HEADER_SETTINGS.get(player), regionData, 3);
        this.regionData = regionData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getTerritoryInfo());
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE));
        this.gui.setItem(2, 2, this.getRenameButton());
        this.gui.setItem(2, 3, this.getChangeDescriptionButton());
        this.gui.setItem(2, 4, this.getChangeColorButton());
        this.gui.setItem(2, 6, this.getChangeOwnershipButton());
        this.gui.setItem(2, 7, this.getDeleteButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new RegionMenu(this.player, this.regionData)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getChangeOwnershipButton() {
        return this.iconManager.get(IconKey.REGION_CHANGE_OWNERSHIP_ICON).setName(Lang.GUI_REGION_CHANGE_CAPITAL.get(this.tanPlayer)).setDescription(Lang.GUI_REGION_CHANGE_CAPITAL_DESC1.get(this.tanPlayer, this.regionData.getCapital().getName()), Lang.GUI_REGION_CHANGE_CAPITAL_DESC2.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            if (!this.regionData.isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.GUI_NEED_TO_BE_LEADER_OF_REGION.get(this.tanPlayer));
                return;
            }
            PlayerGUI.openRegionChangeOwnership(this.player, 0);
        }).asGuiItem(this.player);
    }

    private GuiItem getDeleteButton() {
        return this.iconManager.get(IconKey.REGION_DELETE_REGION_ICON).setName(Lang.GUI_REGION_DELETE.get(this.tanPlayer)).setDescription(Lang.GUI_REGION_DELETE_DESC1.get(this.tanPlayer, this.regionData.getName()), Lang.GUI_REGION_DELETE_DESC2.get(this.tanPlayer), Lang.GUI_REGION_DELETE_DESC3.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            if (!this.regionData.isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.GUI_NEED_TO_BE_LEADER_OF_REGION.get(this.tanPlayer));
                return;
            }
            if (this.regionData.isCapital()) {
                TanChatUtils.message(this.player, Lang.CANNOT_DELETE_TERRITORY_IF_CAPITAL.get(this.tanPlayer, this.regionData.getOverlord().get().getBaseColoredName()));
                return;
            }
            if (!this.player.hasPermission("tan.base.region.disband")) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            PlayerGUI.openConfirmMenu(this.player, Lang.GUI_CONFIRM_DELETE_REGION.get(this.tanPlayer, this.regionData.getName()), confirm -> {
                FileUtil.addLineToHistory(Lang.REGION_DELETED_NEWSLETTER.get(this.player.getName(), this.regionData.getName()));
                EventManager.getInstance().callEvent(new RegionDeletednternalEvent(this.regionData, this.tanPlayer));
                this.regionData.delete();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.GOOD);
                new MainMenu(this.player);
            }, remove -> this.open());
        }).asGuiItem(this.player);
    }
}

