/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChooseWarGoal;
import org.leralix.tan.gui.user.territory.SelectWarGoals;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.impl.FortDataStorage;
import org.leralix.tan.war.War;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.CaptureFortWarGoal;

public class SelectFortForCapture
extends IteratorGUI {
    private final WarRole warRole;
    private final TerritoryData territoryData;
    private final War war;
    private final TerritoryData enemyTerritoryData;

    public SelectFortForCapture(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_SELECT_WARGOAL.get(player), 3);
        this.warRole = warRole;
        this.territoryData = territoryData;
        this.war = war;
        this.enemyTerritoryData = war.isMainAttacker(territoryData) ? war.getMainDefender() : war.getMainAttacker();
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getForts(), p -> new ChooseWarGoal(this.player, this.territoryData, this.war, this.warRole));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getForts() {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        for (Fort fort : FortDataStorage.getInstance().getOwnedFort(this.enemyTerritoryData)) {
            ArrayList<String> description = new ArrayList<String>();
            description.add(Lang.GUI_GENERIC_CLICK_TO_SELECT.get(this.langType, new String[0]));
            items.add(this.iconManager.get(new ItemStack(Material.IRON_BLOCK)).setName(fort.getName()).setDescription(description).setAction(event -> {
                this.war.addGoal(this.warRole, new CaptureFortWarGoal(fort));
                new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole);
            }).asGuiItem(this.player));
        }
        return items;
    }
}

